/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.TabDataExecutor;
import internal.sql.lhod.TabDataQuery;
import internal.sql.lhod.TabDataReader;
import internal.sys.ResourceExtractor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import nbbrd.io.sys.ProcessReader;
import nbbrd.io.win.CScriptWrapper;

final class VbsExecutor
implements TabDataExecutor {
    @NonNull
    private final ResourceExtractor scripts;
    private boolean closed = false;

    @Override
    public TabDataReader exec(TabDataQuery query) throws IOException {
        if (this.closed) {
            throw new IOException("Executor closed");
        }
        return TabDataReader.of(this.exec(query.getProcedure() + ".vbs", query.getParameters().toArray(new String[0])));
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.closed;
    }

    private BufferedReader exec(String scriptName, String[] args) throws IOException {
        File script = this.scripts.getResourceAsFile(scriptName);
        Process process = CScriptWrapper.exec((File)script, (short)-1, (String[])args);
        return ProcessReader.newReader((Process)process);
    }

    public VbsExecutor(@NonNull ResourceExtractor scripts) {
        if (scripts == null) {
            throw new NullPointerException("scripts is marked non-null but is null");
        }
        this.scripts = scripts;
    }
}

