/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.odbc.win;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nbbrd.sql.odbc.OdbcDataSource;
import nbbrd.sql.odbc.OdbcDriver;
import org.checkerframework.checker.nullness.qual.NonNull;

final class WinOdbcRegistryUtil {
    public static final String DATA_SOURCES_KEY = "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources";
    public static final String DATA_SOURCE_KEY = "SOFTWARE\\ODBC\\ODBC.INI";
    public static final String DRIVERS_KEY = "SOFTWARE\\ODBC\\Odbcinst.INI\\ODBC Drivers";
    public static final String DRIVER_KEY = "SOFTWARE\\ODBC\\Odbcinst.INI";
    public static final String KEY_SEPARATOR = "\\";

    public static List<String> getDataSourceNames(Registry reg, OdbcDataSource.Type ... types) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (OdbcDataSource.Type o : types) {
            WinOdbcRegistryUtil.forEachDataSourceName(reg, o, result::add);
        }
        return result;
    }

    private static void forEachDataSourceName(Registry reg, OdbcDataSource.Type type, Consumer<String> consumer) throws IOException {
        Registry.Root root = WinOdbcRegistryUtil.getRoot(type);
        if (reg.keyExists(root, DATA_SOURCES_KEY)) {
            for (String dataSourceName : reg.getValues(root, DATA_SOURCES_KEY).keySet()) {
                consumer.accept(dataSourceName);
            }
        }
    }

    public static List<OdbcDataSource> getDataSources(Registry reg, OdbcDataSource.Type ... types) throws IOException {
        ArrayList<OdbcDataSource> result = new ArrayList<OdbcDataSource>();
        for (OdbcDataSource.Type o : types) {
            WinOdbcRegistryUtil.forEachDataSource(reg, o, result::add);
        }
        return result;
    }

    private static void forEachDataSource(Registry reg, OdbcDataSource.Type type, Consumer<OdbcDataSource> consumer) throws IOException {
        Registry.Root root = WinOdbcRegistryUtil.getRoot(type);
        if (reg.keyExists(root, DATA_SOURCES_KEY)) {
            for (Map.Entry<String, Object> master : reg.getValues(root, DATA_SOURCES_KEY).entrySet()) {
                String dataSourceKey = "SOFTWARE\\ODBC\\ODBC.INI\\" + master.getKey();
                if (!reg.keyExists(root, dataSourceKey)) continue;
                consumer.accept(WinOdbcRegistryUtil.dataSourceOf(type, master, reg.getValues(root, dataSourceKey)));
            }
        }
    }

    private static OdbcDataSource dataSourceOf(OdbcDataSource.Type type, Map.Entry<String, Object> master, Map<String, Object> details) {
        return OdbcDataSource.builder().type(type).name(master.getKey()).description(WinOdbcRegistryUtil.toString(details.get("Description"), null)).driverName(WinOdbcRegistryUtil.toString(master.getValue(), null)).driverPath(WinOdbcRegistryUtil.toFile(details.get("Driver"), null)).serverName(WinOdbcRegistryUtil.toString(details.get("Server"), null)).build();
    }

    public static Registry.Root getRoot(OdbcDataSource.Type type) {
        switch (type) {
            case SYSTEM: {
                return Registry.Root.HKEY_LOCAL_MACHINE;
            }
            case USER: {
                return Registry.Root.HKEY_CURRENT_USER;
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static List<String> getDriverNames(Registry reg) throws IOException {
        if (reg.keyExists(Registry.Root.HKEY_LOCAL_MACHINE, DRIVERS_KEY)) {
            return new ArrayList<String>(reg.getValues(Registry.Root.HKEY_LOCAL_MACHINE, DRIVERS_KEY).keySet());
        }
        return Collections.emptyList();
    }

    public static List<OdbcDriver> getDrivers(Registry reg) throws IOException {
        ArrayList<OdbcDriver> result = new ArrayList<OdbcDriver>();
        Registry.Root localMachine = Registry.Root.HKEY_LOCAL_MACHINE;
        if (reg.keyExists(localMachine, DRIVERS_KEY)) {
            for (String driverName : reg.getValues(localMachine, DRIVERS_KEY).keySet()) {
                String driverKey = "SOFTWARE\\ODBC\\Odbcinst.INI\\" + driverName;
                if (!reg.keyExists(localMachine, driverKey)) continue;
                result.add(WinOdbcRegistryUtil.driverOf(driverName, reg.getValues(localMachine, driverKey)));
            }
        }
        return result;
    }

    private static OdbcDriver driverOf(String driverName, Map<String, Object> details) {
        return OdbcDriver.builder().name(driverName).apiLevel(WinOdbcRegistryUtil.toEnum(details.get("APILevel"), OdbcDriver.ApiLevel.class).orElse(OdbcDriver.ApiLevel.NONE)).connectFunctions(WinOdbcRegistryUtil.toConnectFunctions(details.get("ConnectFunctions"), null)).driverPath(WinOdbcRegistryUtil.toFile(details.get("Driver"), null)).driverOdbcVer(WinOdbcRegistryUtil.toString(details.get("DriverOdbcVer"), null)).fileExtensions(WinOdbcRegistryUtil.toFileExtensions(details.get("FileExtns"))).fileUsage(WinOdbcRegistryUtil.toEnum(details.get("FileUsage"), OdbcDriver.FileUsage.class).orElse(OdbcDriver.FileUsage.NONE)).setupPath(WinOdbcRegistryUtil.toFile(details.get("Setup"), null)).sqlLevel(WinOdbcRegistryUtil.toEnum(details.get("SQLLevel"), OdbcDriver.SqlLevel.class).orElse(OdbcDriver.SqlLevel.SQL_92_ENTRY)).usageCount(WinOdbcRegistryUtil.toInt(details.get("UsageCount"), -1)).build();
    }

    private static String toString(Object obj, String defaultValue) {
        return obj instanceof String ? (String)obj : defaultValue;
    }

    private static File toFile(Object obj, File defaultValue) {
        return obj instanceof String ? new File((String)obj) : defaultValue;
    }

    private static int toInt(Object obj, int defaultValue) {
        return obj instanceof Integer ? (Integer)obj : defaultValue;
    }

    private static <Z extends Enum<Z>> Optional<Z> toEnum(Object obj, Class<Z> enumType) {
        if (obj == null) {
            return Optional.empty();
        }
        try {
            int value = Integer.parseInt(obj.toString());
            return WinOdbcRegistryUtil.toEnum(value, enumType);
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    private static <Z extends Enum<Z>> Optional<Z> toEnum(int value, Class<Z> enumType) {
        for (Enum o : (Enum[])enumType.getEnumConstants()) {
            if (((IntSupplier)((Object)o)).getAsInt() != value) continue;
            return Optional.of(o);
        }
        return Optional.empty();
    }

    private static List<String> toFileExtensions(Object obj) {
        return obj != null ? WinOdbcRegistryUtil.splitToStream(",", obj.toString()).map(WinOdbcRegistryUtil::getFileExtension).filter(o -> !o.isEmpty()).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static @NonNull Stream<String> splitToStream(@NonNull String separator, @NonNull CharSequence input) {
        return Stream.of(input.toString().split(separator, -1));
    }

    private static String getFileExtension(String input) {
        int index = input.lastIndexOf(46);
        return index != -1 ? input.substring(index + 1) : "";
    }

    private static OdbcDriver.ConnectFunctions toConnectFunctions(Object obj, OdbcDriver.ConnectFunctions defaultValue) {
        return obj != null ? OdbcDriver.ConnectFunctions.parse(obj.toString(), defaultValue) : defaultValue;
    }

    private WinOdbcRegistryUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface Registry {
        public boolean keyExists(@NonNull Root var1, @NonNull String var2) throws IOException;

        public @NonNull Map<String, Object> getValues(@NonNull Root var1, @NonNull String var2) throws IOException;

        public static enum Root {
            HKEY_LOCAL_MACHINE,
            HKEY_CURRENT_USER;

        }
    }
}

