/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache;

import com.github.offercat.cache.MultipleCache;
import com.github.offercat.cache.config.CacheProperties;
import com.github.offercat.cache.extra.CacheId;
import com.github.offercat.cache.extra.CacheKeyGenerate;
import com.github.offercat.cache.extra.CacheObject;
import com.github.offercat.cache.extra.GetMulFunction;
import com.github.offercat.cache.inte.AbstractCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MultipleCacheImpl
implements MultipleCache {
    private static final Logger log = LoggerFactory.getLogger(MultipleCacheImpl.class);
    private AbstractCache beginNode;
    private CacheProperties properties;

    @Override
    public <T extends Serializable> T get(String key, Supplier<T> callback) {
        if (ObjectUtils.isEmpty((Object)key)) {
            return null;
        }
        AbstractCache availableCache = this.getAvailableCache(this.beginNode);
        CacheObject cacheObject = this.get(key, availableCache);
        if (cacheObject != null) {
            return availableCache.transferToObject(cacheObject);
        }
        if (callback == null) {
            return null;
        }
        Serializable callbackValue = (Serializable)callback.get();
        if (callbackValue != null) {
            if (this.properties.isLogEnable()) {
                log.info("get | callback function got the object, key = {}", (Object)key);
            }
            this.set(key, callbackValue);
            return (T)callbackValue;
        }
        return null;
    }

    @Override
    public <T extends Serializable> T get(String key, T nullValue, Supplier<T> callback) {
        if (ObjectUtils.isEmpty((Object)key)) {
            return null;
        }
        AbstractCache availableCache = this.getAvailableCache(this.beginNode);
        CacheObject cacheObject = this.get(key, availableCache);
        if (cacheObject != null) {
            Object value = availableCache.transferToObject(cacheObject);
            if (value.equals(nullValue)) {
                return null;
            }
            return value;
        }
        if (callback == null) {
            this.set(key, nullValue);
            return null;
        }
        Serializable callbackValue = (Serializable)callback.get();
        if (callbackValue != null) {
            if (this.properties.isLogEnable()) {
                log.info("get | callback function got the object, key = {}", (Object)key);
            }
            this.set(key, callbackValue);
            return (T)callbackValue;
        }
        if (this.properties.isLogEnable()) {
            log.info("get | backfill null value {}", nullValue);
        }
        this.set(key, nullValue);
        return null;
    }

    private <T extends Serializable> CacheObject get(String key, AbstractCache node) {
        if (node == null) {
            return null;
        }
        CacheObject cacheObject = node.getCacheObject(key);
        if (cacheObject != null) {
            if (this.properties.isLogEnable()) {
                log.info("get | {} got the object, key = {}", (Object)node.getName(), (Object)key);
            }
            return cacheObject;
        }
        AbstractCache nextAvailableCache = this.getAvailableCache(node.getNext());
        CacheObject nextObject = this.get(key, nextAvailableCache);
        if (nextObject != null) {
            Object obj = nextAvailableCache.transferToObject(nextObject);
            CacheObject thisObject = node.transferToCacheObject(obj, nextObject.getSetTime());
            node.setWithBroadcast(key, thisObject);
            return thisObject;
        }
        return null;
    }

    private AbstractCache getAvailableCache(AbstractCache node) {
        if (node == null) {
            return null;
        }
        if (node.getItemProperties().isEnable()) {
            return node;
        }
        return this.getAvailableCache(node.getNext());
    }

    @Override
    public <T extends CacheId<V>, V> Collection<T> getMul(Collection<V> objectIds, CacheKeyGenerate<V> cacheKeyGenerate, GetMulFunction<T, V> getMulFunction) {
        return this.getMul(objectIds, cacheKeyGenerate, getMulFunction, false, null).values();
    }

    @Override
    public <T extends CacheId<V>, V> Collection<T> getMul(Collection<V> objectIds, CacheKeyGenerate<V> cacheKeyGenerate, T nullValue, GetMulFunction<T, V> getMulFunction) {
        return this.getMul(objectIds, cacheKeyGenerate, getMulFunction, true, nullValue).values();
    }

    private <T extends CacheId<V>, V> Map<String, T> getMul(Collection<V> objectIds, CacheKeyGenerate<V> cacheKeyGenerate, GetMulFunction<T, V> getMulFunction, boolean fillBack, T nullValue) {
        if (CollectionUtils.isEmpty(objectIds)) {
            return new HashMap(0);
        }
        HashMap keyIdMap = new HashMap(objectIds.size(), 2.0f);
        objectIds.forEach(objectId -> keyIdMap.put(cacheKeyGenerate.get(objectId), objectId));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(objectIds.size(), 2.0f);
        ArrayList<String> keys = new ArrayList<String>(keyIdMap.keySet());
        AbstractCache availableCache = this.getAvailableCache(this.beginNode);
        Map<String, CacheObject> cacheObjectMap = this.getMul(keys, availableCache);
        if (keys.size() == 0 || getMulFunction == null) {
            return this.transferToObjectMap(cacheObjectMap, availableCache);
        }
        resultMap.putAll(this.transferToObjectMap(cacheObjectMap, availableCache));
        ArrayList unResolveIds = new ArrayList();
        keys.forEach(key -> unResolveIds.add(keyIdMap.get(key)));
        Collection<CacheId> others = getMulFunction.get(unResolveIds);
        if (!CollectionUtils.isEmpty(others)) {
            if (this.properties.isLogEnable()) {
                log.info("getMul | callback function got {} objects", (Object)others.size());
            }
            HashMap callbackMap = new HashMap(others.size());
            others.forEach(item -> callbackMap.put(cacheKeyGenerate.get(item.getObjectId()), item));
            this.setMul(callbackMap);
            resultMap.putAll(callbackMap);
            keys.removeAll(callbackMap.keySet());
        }
        if (fillBack && keys.size() > 0) {
            if (this.properties.isLogEnable()) {
                log.info("getMul | backfill null value, size = {}", (Object)keys.size());
            }
            HashMap nullValueMap = new HashMap(keys.size(), 2.0f);
            keys.forEach(key -> nullValueMap.put(key, nullValue));
            this.setMul(nullValueMap);
        }
        return resultMap;
    }

    private Map<String, CacheObject> getMul(List<String> keys, AbstractCache node) {
        if (node == null) {
            return new HashMap<String, CacheObject>(0);
        }
        HashMap<String, CacheObject> resultMap = node.getMulCacheObject(keys);
        HashMap<String, CacheObject> hashMap = resultMap = resultMap == null ? new HashMap<String, CacheObject>(keys.size(), 2.0f) : resultMap;
        if (this.properties.isLogEnable() && resultMap.size() > 0) {
            log.info("getMul | {} got {} objects", (Object)node.getName(), (Object)resultMap.size());
        }
        keys.removeAll(resultMap.keySet());
        if (keys.size() == 0) {
            return resultMap;
        }
        AbstractCache nextAvailableCache = this.getAvailableCache(node.getNext());
        Map<String, CacheObject> nextResultMap = this.getMul(keys, nextAvailableCache);
        if (!CollectionUtils.isEmpty(nextResultMap)) {
            Map<String, CacheObject> thisCacheObjectMap = this.backfillCacheObjectMap(nextResultMap, node, nextAvailableCache);
            resultMap.putAll(thisCacheObjectMap);
        }
        return resultMap;
    }

    private <T extends CacheId<V>, V> Map<String, CacheObject> backfillCacheObjectMap(Map<String, CacheObject> nextResultMap, AbstractCache thisCache, AbstractCache nextCache) {
        if (CollectionUtils.isEmpty(nextResultMap)) {
            return new HashMap<String, CacheObject>(0);
        }
        HashMap<String, CacheObject> thisCacheObjectMap = new HashMap<String, CacheObject>(nextResultMap.size(), 2.0f);
        nextResultMap.forEach((key, nextObject) -> {
            CacheId object = (CacheId)nextCache.transferToObject((CacheObject)nextObject);
            CacheObject thisObject = thisCache.transferToCacheObject(object, nextObject.getSetTime());
            thisCacheObjectMap.put((String)key, thisObject);
        });
        thisCache.setMulWithBroadcast(thisCacheObjectMap);
        return thisCacheObjectMap;
    }

    @Override
    public <T extends Serializable> void set(String key, T value) {
        this.set(key, value, this.beginNode);
    }

    @Override
    public <T extends Serializable> void setMul(Map<String, T> keyValues) {
        this.setMul(keyValues, this.beginNode);
    }

    private <T extends Serializable> void setMul(Map<String, T> keyValues, AbstractCache node) {
        if (CollectionUtils.isEmpty(keyValues) || node == null) {
            return;
        }
        if (node.getItemProperties().isEnable()) {
            node.setMulWithBroadcast(this.transferToCacheObjectMap(keyValues, node, System.currentTimeMillis()));
        }
        this.setMul(keyValues, node.getNext());
    }

    private <T extends Serializable> void set(String key, T value, AbstractCache node) {
        if (StringUtils.isEmpty((Object)key) || value == null || node == null) {
            return;
        }
        if (node.getItemProperties().isEnable()) {
            CacheObject cacheObject = node.transferToCacheObject(value, System.currentTimeMillis());
            node.setWithBroadcast(key, cacheObject);
        }
        this.set(key, value, node.getNext());
    }

    private <T extends Serializable> Map<String, CacheObject> transferToCacheObjectMap(Map<String, T> keyValues, AbstractCache cache, long time) {
        if (CollectionUtils.isEmpty(keyValues)) {
            return Collections.emptyMap();
        }
        HashMap<String, CacheObject> cacheObjectMap = new HashMap<String, CacheObject>(keyValues.size(), 2.0f);
        keyValues.forEach((key, object) -> cacheObjectMap.put((String)key, cache.transferToCacheObject(object, time)));
        return cacheObjectMap;
    }

    private <T extends Serializable> Map<String, T> transferToObjectMap(Map<String, CacheObject> cacheObjectMap, AbstractCache cache) {
        if (CollectionUtils.isEmpty(cacheObjectMap)) {
            return Collections.emptyMap();
        }
        HashMap objectMap = new HashMap(cacheObjectMap.size(), 2.0f);
        cacheObjectMap.forEach((key, cacheObject) -> {
            Serializable cfr_ignored_0 = (Serializable)objectMap.put(key, cache.transferToObject((CacheObject)cacheObject));
        });
        return objectMap;
    }

    public MultipleCacheImpl(AbstractCache beginNode, CacheProperties properties) {
        this.beginNode = beginNode;
        this.properties = properties;
    }
}

