/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.config;

import com.github.offercat.cache.MultipleCache;
import com.github.offercat.cache.MultipleCacheImpl;
import com.github.offercat.cache.config.CacheFactory;
import com.github.offercat.cache.config.CacheProperties;
import com.github.offercat.cache.inte.ClusterCache;
import com.github.offercat.cache.inte.DirectCache;
import com.github.offercat.cache.inte.LocalCache;
import com.github.offercat.cache.inte.Serializer;
import com.github.offercat.cache.ready.DefaultSerializer;
import com.github.offercat.cache.ready.ThreeLevelCacheFactory;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MultipleCache.class})
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheAutoConfig {
    @Resource
    private CacheProperties cacheProperties;

    @Bean
    @ConditionalOnMissingBean(value={Serializer.class})
    Serializer serializer() {
        return new DefaultSerializer();
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheFactory.class})
    CacheFactory cacheFactory(Serializer serializer) {
        return new ThreeLevelCacheFactory(this.cacheProperties, serializer);
    }

    @Bean
    @ConditionalOnMissingBean(value={LocalCache.class})
    LocalCache localCache(CacheFactory cacheFactory) {
        return cacheFactory.getLocalCacheInstance();
    }

    @Bean
    @ConditionalOnMissingBean(value={DirectCache.class})
    DirectCache directCache(CacheFactory cacheFactory) {
        return cacheFactory.getDirectCacheInstance();
    }

    @Bean
    @ConditionalOnMissingBean(value={ClusterCache.class})
    ClusterCache clusterCache(CacheFactory cacheFactory) {
        return cacheFactory.getClusterCacheInstance();
    }

    @Bean
    @ConditionalOnMissingBean(value={MultipleCache.class})
    MultipleCache multipleCache(LocalCache localCache, DirectCache directCache, ClusterCache clusterCache) {
        localCache.setNext(directCache).setNext(clusterCache);
        return new MultipleCacheImpl(localCache, this.cacheProperties);
    }
}

