/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.config;

import com.github.offercat.cache.broadcast.BroadcastServiceImpl;
import com.github.offercat.cache.config.CacheProperties;
import com.github.offercat.cache.inte.AbstractCache;
import com.github.offercat.cache.inte.ClusterCache;
import com.github.offercat.cache.inte.DirectCache;
import com.github.offercat.cache.inte.LocalCache;
import com.github.offercat.cache.inte.Serializer;
import com.github.offercat.cache.proxy.CacheAspect;
import com.github.offercat.cache.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.List;

public abstract class CacheFactory {
    protected CacheProperties properties;
    protected Serializer serializer;
    private static List<AbstractCache> REGISTER_CACHE_LIST = new ArrayList<AbstractCache>();

    protected <T extends AbstractCache> T initInstance(T target) {
        BroadcastServiceImpl broadcastService = this.properties.isBroadcastEnable() ? new BroadcastServiceImpl(this.properties, this.serializer, REGISTER_CACHE_LIST) : null;
        CommonProxy<T> proxy = new CommonProxy<T>();
        AbstractCache cache = (AbstractCache)proxy.getProxy(target, new CacheAspect(target, this.properties, broadcastService));
        REGISTER_CACHE_LIST.add(cache);
        return (T)cache;
    }

    public abstract LocalCache getLocalCacheInstance();

    public abstract ClusterCache getClusterCacheInstance();

    public abstract DirectCache getDirectCacheInstance();

    public CacheFactory(CacheProperties properties, Serializer serializer) {
        this.properties = properties;
        this.serializer = serializer;
    }
}

