/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.offercat.cache.config.CacheProperties;
import com.github.offercat.cache.config.ItemProperties;
import io.nats.client.Connection;
import io.nats.client.Nats;
import java.io.IOException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class MiddlewareCreator {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareCreator.class);
    private static volatile Connection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getConnection(CacheProperties properties) {
        if (connection != null) return connection;
        Class<Connection> clazz = Connection.class;
        synchronized (Connection.class) {
            if (connection != null) return connection;
            log.info("Init nats connection\uff0ctopic = {} uri : {}", (Object)("multiple.cache.sync:1.0:" + properties.getBroadcastTopic().trim()), (Object)properties.getNatsUri());
            try {
                connection = Nats.connect((String)properties.getNatsUri());
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            return connection;
        }
    }

    public static Cache<String, Object> createCaffeine(ItemProperties itemProperties) {
        log.info("Init Caffeine local cache, uniform expiration time is {} {}", (Object)itemProperties.getTimeout(), (Object)itemProperties.getTimeunit());
        Caffeine caffeineBuilder = Caffeine.newBuilder().initialCapacity(itemProperties.getMaxSize() / 2).maximumSize((long)itemProperties.getMaxSize());
        Cache caffeine = ItemProperties.ExpireMode.TTL == itemProperties.getExpireMode() ? caffeineBuilder.expireAfterWrite(itemProperties.getTimeout(), itemProperties.getTimeunit()).build() : caffeineBuilder.expireAfterAccess(itemProperties.getTimeout(), itemProperties.getTimeunit()).build();
        return caffeine;
    }

    public static JedisPool createJedisPool(ItemProperties itemProperties) {
        log.info("Init redis cluster cache, uniform expiration time is {} {}", (Object)itemProperties.getTimeout(), (Object)itemProperties.getTimeunit());
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(50);
        poolConfig.setMinIdle(10);
        poolConfig.setMaxIdle(30);
        return new JedisPool((GenericObjectPoolConfig)poolConfig, itemProperties.getAddress(), itemProperties.getPort(), 10000, itemProperties.getPassword());
    }
}

