/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.inte;

import com.github.offercat.cache.action.BaseAction;
import com.github.offercat.cache.broadcast.Broadcast;
import com.github.offercat.cache.broadcast.WithBroadcast;
import com.github.offercat.cache.config.ItemProperties;
import com.github.offercat.cache.extra.CacheObject;
import com.github.offercat.cache.extra.ExceptionUtil;
import com.github.offercat.cache.proxy.UnIntercept;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCache
implements BaseAction,
WithBroadcast {
    private static final Logger log = LoggerFactory.getLogger(AbstractCache.class);
    private String name;
    private int order;
    private AbstractCache next;
    private AbstractCache prev;
    private ItemProperties itemProperties;

    public AbstractCache(String name, ItemProperties itemProperties) {
        ExceptionUtil.paramNull(name, "Cache name cannot be null\uff01");
        ExceptionUtil.paramNull(itemProperties, "Cache properties cannot be null\uff01");
        this.order = 1;
        this.name = name;
        this.itemProperties = itemProperties;
        if (itemProperties.isEnable()) {
            this.initMiddleware(itemProperties);
        }
    }

    public abstract void initMiddleware(ItemProperties var1);

    @UnIntercept
    public AbstractCache setNext(AbstractCache next) {
        ExceptionUtil.paramNull(next, "Next node cannot be null\uff01");
        this.next = next;
        next.order = this.order + 1;
        next.prev = this;
        return next;
    }

    @UnIntercept
    public String getName() {
        return this.name;
    }

    @UnIntercept
    public int getOrder() {
        return this.order;
    }

    @UnIntercept
    public AbstractCache getNext() {
        return this.next;
    }

    @UnIntercept
    public AbstractCache getPrev() {
        return this.prev;
    }

    @UnIntercept
    public ItemProperties getItemProperties() {
        return this.itemProperties;
    }

    @Override
    @Broadcast(type=Broadcast.OperationType.SET_ONE)
    public void setWithBroadcast(String key, CacheObject cacheObject) {
        this.setCacheObject(key, cacheObject);
    }

    @Override
    @Broadcast(type=Broadcast.OperationType.SET_MUL)
    public void setMulWithBroadcast(Map<String, CacheObject> keyObjects) {
        this.setMulCacheObject(keyObjects);
    }

    @Override
    @Broadcast(type=Broadcast.OperationType.DEL_ONE)
    public void delWithBroadcast(String key) {
        this.del(key);
    }

    @Override
    @Broadcast(type=Broadcast.OperationType.DEL_MUL)
    public void delMulWithBroadcast(List<String> keys) {
        this.delMul(keys);
    }

    public AbstractCache() {
    }
}

