/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.proxy;

import com.github.offercat.cache.broadcast.Broadcast;
import com.github.offercat.cache.broadcast.BroadcastMessage;
import com.github.offercat.cache.broadcast.BroadcastObject;
import com.github.offercat.cache.broadcast.BroadcastService;
import com.github.offercat.cache.config.CacheProperties;
import com.github.offercat.cache.extra.CacheObject;
import com.github.offercat.cache.extra.ThrowFunction;
import com.github.offercat.cache.inte.AbstractCache;
import com.github.offercat.cache.proxy.AbstractAop;
import com.github.offercat.cache.proxy.ProxyPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheAspect
extends AbstractAop {
    private static final Logger log = LoggerFactory.getLogger(CacheAspect.class);
    private AbstractCache target;
    private CacheProperties properties;
    private BroadcastService broadcastService;

    @Override
    public Object around(ProxyPoint point, ThrowFunction<Object> function) throws Throwable {
        if (this.target.getItemProperties().isEnable()) {
            return function.get();
        }
        return null;
    }

    @Override
    public void afterReturning(ProxyPoint point) {
        if (this.target.supportBroadcast() && this.properties.isBroadcastEnable() && this.target.getItemProperties().isBroadcastEnable()) {
            Broadcast broadcast = point.getMethod().getAnnotation(Broadcast.class);
            if (broadcast == null) {
                return;
            }
            if (Broadcast.OperationType.SET_ONE.equals((Object)broadcast.type())) {
                this.setOne(point);
            } else if (Broadcast.OperationType.SET_MUL.equals((Object)broadcast.type())) {
                this.setMul(point);
            } else if (Broadcast.OperationType.DEL_ONE.equals((Object)broadcast.type())) {
                this.delOne(point);
            } else if (Broadcast.OperationType.DEL_MUL.equals((Object)broadcast.type())) {
                this.delMul(point);
            } else {
                log.warn("doAfterLocalCacheChange | unknown broadcast type");
            }
        }
    }

    private void setOne(ProxyPoint point) {
        CacheObject cacheObject = (CacheObject)point.getArgs()[1];
        BroadcastObject broadcastObject = new BroadcastObject((String)point.getArgs()[0], cacheObject);
        this.broadcastService.enqueue(new BroadcastMessage(BroadcastService.THIS_SERVER_FLAG, this.target.getName(), false, Collections.singletonList(broadcastObject)));
    }

    private void setMul(ProxyPoint point) {
        Map cacheObjectMap = (Map)point.getArgs()[0];
        ArrayList<BroadcastObject> broadcastObjectList = new ArrayList<BroadcastObject>(cacheObjectMap.size());
        cacheObjectMap.forEach((key, cacheObject) -> broadcastObjectList.add(new BroadcastObject((String)key, (CacheObject)cacheObject)));
        this.broadcastService.enqueue(new BroadcastMessage(BroadcastService.THIS_SERVER_FLAG, this.target.getName(), false, broadcastObjectList));
    }

    private void delOne(ProxyPoint point) {
        BroadcastObject broadcastObject = new BroadcastObject((String)point.getArgs()[0], null);
        this.broadcastService.enqueue(new BroadcastMessage(BroadcastService.THIS_SERVER_FLAG, this.target.getName(), true, Collections.singletonList(broadcastObject)));
    }

    private void delMul(ProxyPoint point) {
        Collection keys = (Collection)point.getArgs()[0];
        ArrayList<BroadcastObject> broadcastObjectList = new ArrayList<BroadcastObject>(keys.size());
        keys.forEach(key -> broadcastObjectList.add(new BroadcastObject((String)key, null)));
        this.broadcastService.enqueue(new BroadcastMessage(BroadcastService.THIS_SERVER_FLAG, this.target.getName(), true, broadcastObjectList));
    }

    public CacheAspect(AbstractCache target, CacheProperties properties, BroadcastService broadcastService) {
        this.target = target;
        this.properties = properties;
        this.broadcastService = broadcastService;
    }
}

