/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.proxy;

import com.github.offercat.cache.proxy.AbstractAop;
import com.github.offercat.cache.proxy.ProxyPoint;
import com.github.offercat.cache.proxy.UnIntercept;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class CommonProxy<T>
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CommonProxy.class);
    private T target;
    private AbstractAop aop;
    private static final List<String> INTERCEPT_WHITE_LIST = Arrays.asList("toString", "supportBroadcast", "initMiddleware");

    public T getProxy(T target, AbstractAop aop) {
        this.target = target;
        this.aop = aop;
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(target.getClass());
        enhancer.setCallback((Callback)this);
        return (T)enhancer.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Object o, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        UnIntercept unIntercept = method.getAnnotation(UnIntercept.class);
        if (unIntercept != null || INTERCEPT_WHITE_LIST.contains(method.getName())) {
            return methodProxy.invoke(this.target, args);
        }
        ProxyPoint point = new ProxyPoint(o, method, args);
        try {
            Object result;
            try {
                result = this.aop.around(point, () -> {
                    this.aop.before(point);
                    return methodProxy.invoke(this.target, args);
                });
            }
            finally {
                this.aop.after(point);
            }
            this.aop.afterReturning(point);
            return result;
        }
        catch (Throwable e) {
            this.aop.afterThrowing(point, e);
            e.printStackTrace();
            return null;
        }
    }
}

