/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.ready;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.offercat.cache.config.ItemProperties;
import com.github.offercat.cache.config.MiddlewareCreator;
import com.github.offercat.cache.extra.CacheObject;
import com.github.offercat.cache.extra.ExceptionUtil;
import com.github.offercat.cache.inte.LocalCache;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CaffeineCache
extends LocalCache {
    private Cache<String, Object> caffeine;

    public CaffeineCache(String name, ItemProperties itemProperties) {
        super(name, itemProperties);
    }

    @Override
    public void initMiddleware(ItemProperties itemProperties) {
        ExceptionUtil.paramPositive(itemProperties.getMaxSize(), "Max size must be greater than 0!");
        ExceptionUtil.paramPositive(itemProperties.getTimeout(), "Expiration time must be greater than 0!");
        if (this.caffeine == null) {
            this.caffeine = MiddlewareCreator.createCaffeine(itemProperties);
        }
    }

    @Override
    public boolean supportBroadcast() {
        return true;
    }

    @Override
    public <T extends Serializable> T get(String key) {
        CacheObject cacheObject = this.getCacheObject(key);
        return (T)(cacheObject == null ? null : (Serializable)cacheObject.getObject());
    }

    @Override
    public <T extends Serializable> Map<String, T> getMul(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashMap(0);
        }
        Map cacheResult = this.caffeine.getAllPresent(keys);
        HashMap result = new HashMap(cacheResult.size(), 2.0f);
        cacheResult.forEach((key, obj) -> {
            if (obj instanceof CacheObject) {
                CacheObject cacheObject = (CacheObject)obj;
                result.put(key, (Serializable)cacheObject.getObject());
            }
        });
        return result;
    }

    @Override
    public <T extends Serializable> void set(String key, T value) {
        if (key == null || value == null) {
            return;
        }
        CacheObject cacheObject = new CacheObject(value.getClass().getName(), value, System.currentTimeMillis());
        this.setCacheObject(key, cacheObject);
    }

    @Override
    public <T extends Serializable> void setMul(Map<String, T> keyObjects) {
        if (CollectionUtils.isEmpty(keyObjects)) {
            return;
        }
        long time = System.currentTimeMillis();
        HashMap<String, CacheObject> objectMap = new HashMap<String, CacheObject>(keyObjects.size(), 2.0f);
        keyObjects.forEach((key, value) -> {
            CacheObject cacheObject = new CacheObject(value.getClass().getName(), value, time);
            objectMap.put((String)key, cacheObject);
        });
        this.setMulCacheObject(objectMap);
    }

    @Override
    public void del(String key) {
        if (key == null) {
            return;
        }
        this.caffeine.invalidate((Object)key);
    }

    @Override
    public void delMul(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        this.caffeine.invalidateAll(keys);
    }

    @Override
    public void setCacheObject(String key, CacheObject cacheObject) {
        if (StringUtils.isEmpty((Object)key) || cacheObject == null) {
            return;
        }
        this.caffeine.put((Object)key, (Object)cacheObject);
    }

    @Override
    public void setMulCacheObject(Map<String, CacheObject> keyObjects) {
        if (CollectionUtils.isEmpty(keyObjects)) {
            return;
        }
        this.caffeine.putAll(keyObjects);
    }

    @Override
    public CacheObject getCacheObject(String key) {
        if (key == null) {
            return null;
        }
        return (CacheObject)this.caffeine.getIfPresent((Object)key);
    }

    @Override
    public Map<String, CacheObject> getMulCacheObject(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashMap<String, CacheObject>(0);
        }
        Map cacheResult = this.caffeine.getAllPresent(keys);
        HashMap<String, CacheObject> result = new HashMap<String, CacheObject>(cacheResult.size(), 2.0f);
        cacheResult.forEach((key, obj) -> {
            if (obj instanceof CacheObject) {
                result.put((String)key, (CacheObject)obj);
            }
        });
        return result;
    }

    @Override
    public <T extends Serializable> T transferToObject(CacheObject cacheObject) {
        if (cacheObject == null || cacheObject.getObject() == null) {
            return null;
        }
        return (T)((Serializable)cacheObject.getObject());
    }

    @Override
    public <T extends Serializable> CacheObject transferToCacheObject(T obj, long time) {
        if (obj == null) {
            return null;
        }
        return new CacheObject(obj.getClass().getName(), obj, time);
    }

    public CaffeineCache() {
    }
}

