/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.ready;

import com.github.offercat.cache.config.ItemProperties;
import com.github.offercat.cache.config.MiddlewareCreator;
import com.github.offercat.cache.extra.CacheObject;
import com.github.offercat.cache.extra.ExceptionUtil;
import com.github.offercat.cache.inte.ClusterCache;
import com.github.offercat.cache.inte.Serializer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPool;

public class RedisCache
extends ClusterCache {
    private JedisPool jedisPool;
    private ExecutorService asyncPool;
    private Serializer serializer;

    public RedisCache(String name, Serializer serializer, ItemProperties itemProperties) {
        super(name, itemProperties);
        this.serializer = serializer;
    }

    @Override
    public void initMiddleware(ItemProperties itemProperties) {
        ExceptionUtil.paramPositive(itemProperties.getTimeout(), "Expiration time must be greater than 0!");
        this.jedisPool = MiddlewareCreator.createJedisPool(itemProperties);
        this.asyncPool = new ThreadPoolExecutor(5, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new ThreadFactoryBuilder().setNameFormat("RedisCache Pool-%d").setDaemon(false).build(), new ThreadPoolExecutor.AbortPolicy());
    }

    @Override
    public boolean supportBroadcast() {
        return false;
    }

    @Override
    public <T extends Serializable> T get(String key) {
        CacheObject cacheObject = this.getCacheObject(key);
        if (cacheObject == null) {
            return null;
        }
        return this.transferToObject(cacheObject);
    }

    @Override
    public <T extends Serializable> Map<String, T> getMul(List<String> keys) {
        HashMap result = new HashMap(keys.size(), 2.0f);
        if (StringUtils.isEmpty(keys)) {
            return result;
        }
        List strObjList = this.jedisPool.getResource().mget(keys.toArray(new String[0]));
        Class<?> type = null;
        for (int i = 0; i < strObjList.size(); ++i) {
            if (strObjList.get(i) == null) continue;
            CacheObject cacheObject = this.serializer.deserializeFromString((String)strObjList.get(i), CacheObject.class);
            if (type == null) {
                try {
                    type = Class.forName(cacheObject.getTypeStr());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            result.put(keys.get(i), this.serializer.deserializeFromString((String)cacheObject.getObject(), type));
        }
        return result;
    }

    @Override
    public <T extends Serializable> void set(String key, T value) {
        if (StringUtils.isEmpty((Object)key) || value == null) {
            return;
        }
        String strCacheObject = this.serializer.serializeToString(value);
        CacheObject cacheObject = this.transferToCacheObject(strCacheObject, System.currentTimeMillis());
        this.setCacheObject(key, cacheObject);
    }

    @Override
    public <T extends Serializable> void setMul(Map<String, T> keyObjects) {
        if (CollectionUtils.isEmpty(keyObjects)) {
            return;
        }
        String[] keyValues = new String[keyObjects.size() * 2];
        int i = 0;
        for (Map.Entry<String, T> entry : keyObjects.entrySet()) {
            if (StringUtils.isEmpty((Object)entry.getKey()) || entry.getValue() == null) continue;
            CacheObject cacheObject = new CacheObject(entry.getValue().getClass().getName(), this.serializer.serializeToString((Serializable)entry.getValue()), System.currentTimeMillis());
            keyValues[i] = entry.getKey();
            keyValues[i + 1] = this.serializer.serializeToString(cacheObject);
            i += 2;
        }
        this.jedisPool.getResource().mset(keyValues);
        int expireSeconds = this.getTimeUnitToMillisecond();
        this.asyncPool.execute(() -> keyObjects.keySet().forEach(key -> this.jedisPool.getResource().expire(key, expireSeconds)));
    }

    @Override
    public void del(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        this.jedisPool.getResource().del(key);
    }

    @Override
    public void delMul(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        this.jedisPool.getResource().del(keys.toArray(new String[0]));
    }

    @Override
    public void setCacheObject(String key, CacheObject cacheObject) {
        if (StringUtils.isEmpty((Object)key) || cacheObject == null) {
            return;
        }
        String cacheObjectStr = this.serializer.serializeToString(cacheObject);
        this.jedisPool.getResource().setex(key, this.getTimeUnitToMillisecond(), cacheObjectStr);
    }

    @Override
    public void setMulCacheObject(Map<String, CacheObject> keyObjects) {
        if (CollectionUtils.isEmpty(keyObjects)) {
            return;
        }
        String[] keyValues = new String[keyObjects.size() * 2];
        int i = 0;
        for (Map.Entry<String, CacheObject> entry : keyObjects.entrySet()) {
            if (StringUtils.isEmpty((Object)entry.getKey()) || entry.getValue() == null) continue;
            keyValues[i] = entry.getKey();
            keyValues[i + 1] = this.serializer.serializeToString((Serializable)entry.getValue());
            i += 2;
        }
        this.jedisPool.getResource().mset(keyValues);
        int expireSeconds = this.getTimeUnitToMillisecond();
        this.asyncPool.execute(() -> keyObjects.keySet().forEach(key -> this.jedisPool.getResource().expire(key, expireSeconds)));
    }

    @Override
    public CacheObject getCacheObject(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        String cacheObjectStr = this.jedisPool.getResource().get(key);
        if (StringUtils.isEmpty((Object)cacheObjectStr)) {
            return null;
        }
        return this.serializer.deserializeFromString(cacheObjectStr, CacheObject.class);
    }

    @Override
    public Map<String, CacheObject> getMulCacheObject(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        HashMap<String, CacheObject> cacheObjectMap = new HashMap<String, CacheObject>(keys.size(), 2.0f);
        List strObjList = this.jedisPool.getResource().mget(keys.toArray(new String[0]));
        for (int i = 0; i < strObjList.size(); ++i) {
            if (strObjList.get(i) == null) continue;
            CacheObject cacheObject = this.serializer.deserializeFromString((String)strObjList.get(i), CacheObject.class);
            cacheObjectMap.put(keys.get(i), cacheObject);
        }
        return cacheObjectMap;
    }

    @Override
    public <T extends Serializable> T transferToObject(CacheObject cacheObject) {
        Class<?> type;
        if (cacheObject == null || cacheObject.getObject() == null || StringUtils.isEmpty((Object)cacheObject.getTypeStr())) {
            return null;
        }
        String objStr = (String)cacheObject.getObject();
        try {
            type = Class.forName(cacheObject.getTypeStr());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return (T)this.serializer.deserializeFromString(objStr, type);
    }

    @Override
    public <T extends Serializable> CacheObject transferToCacheObject(T obj, long time) {
        if (obj == null) {
            return null;
        }
        return new CacheObject(obj.getClass().getName(), this.serializer.serializeToString(obj), time);
    }

    private int getTimeUnitToMillisecond() {
        long result = -1L;
        long timeout = this.getItemProperties().getTimeout();
        TimeUnit timeUnit = this.getItemProperties().getTimeunit();
        if (timeUnit == TimeUnit.SECONDS) {
            result = timeout;
        } else if (timeUnit == TimeUnit.MINUTES) {
            result = timeout * 60L;
        } else if (timeUnit == TimeUnit.HOURS) {
            result = timeout * 60L * 60L;
        } else if (timeUnit == TimeUnit.DAYS) {
            result = timeout * 60L * 60L * 24L;
        }
        if (result == -1L) {
            throw new InvalidParameterException("The minimum unit of Redis cache is seconds!");
        }
        if (result > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Redis cache expiration time exceeds the maximum range!");
        }
        return (int)result;
    }

    @Override
    public <T> Map<String, T> getMap(String key) {
        return null;
    }

    @Override
    public <T> void setMap(String key, Map<String, T> map) {
    }

    @Override
    public <T> T getMapField(String key, String field) {
        return null;
    }

    @Override
    public <T> void setMapField(String key, String field, T value) {
    }

    public RedisCache() {
    }
}

