/*
 * Decompiled with CFR 0.152.
 */
package com.github.offercat.cache.ready;

import com.github.offercat.cache.config.CacheFactory;
import com.github.offercat.cache.config.CacheProperties;
import com.github.offercat.cache.config.ItemProperties;
import com.github.offercat.cache.inte.ClusterCache;
import com.github.offercat.cache.inte.DirectCache;
import com.github.offercat.cache.inte.LocalCache;
import com.github.offercat.cache.inte.Serializer;
import com.github.offercat.cache.ready.CaffeineCache;
import com.github.offercat.cache.ready.EhDirectCache;
import com.github.offercat.cache.ready.RedisCache;

public class ThreeLevelCacheFactory
extends CacheFactory {
    public ThreeLevelCacheFactory(CacheProperties properties, Serializer serializer) {
        super(properties, serializer);
    }

    @Override
    public LocalCache getLocalCacheInstance() {
        ItemProperties itemProperties = this.properties.getConfig().get("local");
        CaffeineCache caffeineCache = new CaffeineCache("local", itemProperties);
        return this.initInstance(caffeineCache);
    }

    @Override
    public ClusterCache getClusterCacheInstance() {
        ItemProperties itemProperties = this.properties.getConfig().get("cluster");
        RedisCache redisCache = new RedisCache("cluster", this.serializer, itemProperties);
        return this.initInstance(redisCache);
    }

    @Override
    public DirectCache getDirectCacheInstance() {
        ItemProperties itemProperties = this.properties.getConfig().get("direct");
        EhDirectCache ehDirectCache = new EhDirectCache("direct", this.serializer, itemProperties);
        return this.initInstance(ehDirectCache);
    }
}

