/*
 * Decompiled with CFR 0.152.
 */
package com.github.peiatgithub.java.utils;

import java.util.concurrent.TimeUnit;

public class NanoStopWatch {
    private static boolean running = false;
    private static long begin;

    private NanoStopWatch() {
        throw new RuntimeException();
    }

    public static void begin() {
        begin = System.nanoTime();
        running = true;
    }

    public static void stop() {
        running = false;
    }

    public static long getMillis() {
        return NanoStopWatch.getElapsed(TimeUnit.MILLISECONDS, false);
    }

    public static long getNanos() {
        return NanoStopWatch.getElapsed(TimeUnit.NANOSECONDS, false);
    }

    public static long stopAndGetMillis() {
        return NanoStopWatch.getElapsed(TimeUnit.MILLISECONDS, true);
    }

    public static long stopAndGetNanos() {
        return NanoStopWatch.getElapsed(TimeUnit.NANOSECONDS, true);
    }

    private static long getElapsed(TimeUnit tu, boolean stop) {
        long elapsed = System.nanoTime() - begin;
        if (running) {
            if (stop) {
                running = false;
            }
            switch (tu) {
                case MILLISECONDS: {
                    return TimeUnit.NANOSECONDS.toMillis(elapsed);
                }
                case NANOSECONDS: {
                    return elapsed;
                }
            }
            throw new RuntimeException("Unsupported TimeUnit: " + tu.name());
        }
        return 0L;
    }
}

