/*
 * Decompiled with CFR 0.152.
 */
package com.github.peiatgithub.java.utils;

import com.github.peiatgithub.java.utils.function.NonArgFunction;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import java.util.stream.IntStream;

public class Utils {
    public static void printlnWithThreadName(String message) {
        System.out.format("%s: %s%n", Thread.currentThread().getName(), message);
    }

    public static Throwable catchThrowable(NonArgFunction function) {
        try {
            function.doSth();
            return null;
        }
        catch (Throwable t) {
            return t;
        }
    }

    public static void repeatRun(int times, NonArgFunction function) {
        IntStream.range(0, times).forEach(i -> function.doSth());
    }

    public static void repeatRun(int times, Consumer<Integer> c) {
        IntStream.range(0, times).forEach(i -> c.accept(i));
    }

    public static String bytesToReadable(double numOfBytes) {
        if (numOfBytes < 0.0) {
            throw new IllegalArgumentException("Number of bytes must bigger than or equal to 0.");
        }
        DecimalFormat df = new DecimalFormat("#.#");
        if (numOfBytes >= 1.073741824E9) {
            return df.format(numOfBytes / 1.073741824E9) + " GB";
        }
        if (numOfBytes >= 1048576.0) {
            return df.format(numOfBytes / 1048576.0) + " MB";
        }
        if (numOfBytes >= 1024.0) {
            return df.format(numOfBytes / 1024.0) + " KB";
        }
        return df.format(numOfBytes) + " Bytes";
    }

    public static String numberToReadable(long num) {
        String r;
        String result = "";
        double numAbs = Math.abs(num);
        DecimalFormat df = new DecimalFormat("#.#");
        result = numAbs >= 1.0E9 ? df.format(numAbs / 1.0E9).toString() + " Bn" : (numAbs >= 1000000.0 ? ((r = df.format(numAbs / 1000000.0).toString()).equals("1000") ? "1 Bn" : r + " Mn") : (numAbs >= 1000.0 ? ((r = df.format(numAbs / 1000.0).toString()).equals("1000") ? "1 Mn" : r + " K") : String.valueOf(numAbs)));
        if (num < 0L) {
            result = "-" + result;
        }
        return result;
    }

    public static void threadSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static Thread createAndStartThread(Runnable r) {
        Thread t = new Thread(r);
        t.start();
        return t;
    }

    public static void threadJoin(Thread thr) {
        try {
            thr.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getSubString(String str, String delimiter, int n1, int n2) {
        if (n2 <= n1) {
            return "";
        }
        try {
            int resultBeginIdx = 0;
            int delimiterIdx = -1;
            for (int i = 0; i <= n2; ++i) {
                if ((delimiterIdx = str.indexOf(delimiter, delimiterIdx + 1)) == -1) {
                    return "";
                }
                if (i != n1) continue;
                resultBeginIdx = delimiterIdx + 1;
            }
            return str.substring(resultBeginIdx, delimiterIdx);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public static void ifNotNull(Object obj, NonArgFunction fnc) {
        Utils.ifThen(obj != null, fnc);
    }

    public static void ifNull(Object obj, NonArgFunction fnc) {
        Utils.ifThen(obj == null, fnc);
    }

    public static void ifThen(boolean flag, NonArgFunction fnc) {
        if (flag) {
            fnc.doSth();
        }
    }

    public static void ifElse(boolean flag, NonArgFunction fnc1, NonArgFunction fnc2) {
        if (flag) {
            fnc1.doSth();
        } else {
            fnc2.doSth();
        }
    }

    public static int intsSum(int ... numbers) {
        int sum = 0;
        for (int num : numbers) {
            sum += num;
        }
        return sum;
    }

    public static void clearStringBuilder(StringBuilder sb) {
        sb.setLength(0);
    }

    public static String onlyFirstCapital(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() <= 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }
}

