/*
 * Decompiled with CFR 0.152.
 */
package com.github.peiatgithub.java.utils.xml;

import com.github.peiatgithub.java.utils.Utils;

public class XpathBuilder {
    private StringBuilder xpath = new StringBuilder("");

    public static XpathBuilder newBuilder() {
        return new XpathBuilder();
    }

    public XpathBuilder append(String text) {
        this.xpath.append(text);
        return this;
    }

    public XpathBuilder node(String nodeName) {
        return this.append(nodeName);
    }

    public XpathBuilder condition(String condition) {
        return this.append(String.format("[%s]", condition));
    }

    public XpathBuilder withContent(String content) {
        return this.condition(String.format(".='%s'", content));
    }

    public XpathBuilder contentContains(String content) {
        return this.condition(String.format("contains(., '%s')", content));
    }

    public XpathBuilder attribute(String attributeName) {
        return this.append(String.format("@%s", attributeName));
    }

    public XpathBuilder withAttribute(String attributeName, String attributeValue) {
        return this.condition(String.format("@%s='%s'", attributeName, attributeValue));
    }

    public XpathBuilder attributeContains(String attributeName, String attributeValuePart) {
        return this.condition(String.format("contains(@%s, '%s')", attributeName, attributeValuePart));
    }

    public XpathBuilder index(int index) {
        return this.append(String.format("[%d]", index));
    }

    public XpathBuilder indexFromLast(int indexFromLast) {
        return this.append(String.format("[last() - %d]", indexFromLast - 1));
    }

    public XpathBuilder position(int p) {
        return this.condition(String.format("position() = %d", p));
    }

    public XpathBuilder precedingSibling(boolean all) {
        this.appendTailSlashIfNotPresent();
        this.xpath.append("preceding-sibling::");
        if (all) {
            this.xpath.append("*");
        }
        return this;
    }

    public XpathBuilder followingSibling(boolean all) {
        this.appendTailSlashIfNotPresent();
        this.xpath.append("following-sibling::");
        if (all) {
            this.xpath.append("*");
        }
        return this;
    }

    public XpathBuilder ancestor(boolean all, boolean selfInclusive) {
        this.appendTailSlashIfNotPresent();
        if (selfInclusive) {
            this.xpath.append("ancestor-or-self::");
        } else {
            this.xpath.append("ancestor::");
        }
        if (all) {
            this.xpath.append("*");
        }
        return this;
    }

    public XpathBuilder descendant(boolean all, boolean selfInclusive) {
        this.appendTailSlashIfNotPresent();
        if (selfInclusive) {
            this.xpath.append("descendant-or-self::");
        } else {
            this.xpath.append("descendant::");
        }
        if (all) {
            this.xpath.append("*");
        }
        return this;
    }

    public XpathBuilder nodeWithContent(String nodeName, String content) {
        return this.node(nodeName).withContent(content);
    }

    public XpathBuilder nodeContentContains(String tagName, String content) {
        return this.node(tagName).contentContains(content);
    }

    public XpathBuilder nodeWithAttribute(String nodeName, String attributeName, String attributeValue) {
        return this.node(nodeName).withAttribute(attributeName, attributeValue);
    }

    public XpathBuilder nodeAttributeContains(String nodeName, String attributeName, String attributeValuePart) {
        return this.node(nodeName).attributeContains(attributeName, attributeValuePart);
    }

    public XpathBuilder nodeIndex(String nodeName, int index) {
        return this.node(nodeName).index(index);
    }

    public XpathBuilder nodeIndexFromLast(String tagName, int indexFromLast) {
        return this.node(tagName).indexFromLast(indexFromLast);
    }

    public XpathBuilder down(int n) {
        if (this.xpath.toString().endsWith("//")) {
            return this;
        }
        if (n <= 0) {
            return this;
        }
        if (this.xpath.toString().endsWith("/")) {
            this.xpath.append(".");
        }
        for (int i = 1; i <= n - 1; ++i) {
            this.xpath.append("/.");
        }
        this.xpath.append("/");
        return this;
    }

    public XpathBuilder down() {
        return this.down(1);
    }

    public XpathBuilder down(String nodeName) {
        return this.down().node(nodeName);
    }

    public XpathBuilder up(int n) {
        if (this.xpath.toString().endsWith("//")) {
            return this;
        }
        if (n <= 0) {
            return this;
        }
        if (this.xpath.toString().endsWith("/")) {
            this.xpath.append("..");
        } else {
            this.xpath.append("/..");
        }
        for (int i = 1; i <= n - 1; ++i) {
            this.xpath.append("/..");
        }
        this.xpath.append("/");
        return this;
    }

    public XpathBuilder up() {
        return this.up(1);
    }

    public XpathBuilder up(String nodeName) {
        return this.up().node(nodeName);
    }

    public XpathBuilder startFromRoot() {
        Utils.clearStringBuilder(this.xpath);
        return this.append("/");
    }

    public XpathBuilder startFromRoot(String nodeName) {
        Utils.clearStringBuilder(this.xpath);
        return this.append("/" + nodeName);
    }

    public XpathBuilder startFromAnywhere() {
        Utils.clearStringBuilder(this.xpath);
        return this.append("//");
    }

    public XpathBuilder startFromAnywhere(String nodeName) {
        Utils.clearStringBuilder(this.xpath);
        return this.append("//" + nodeName);
    }

    public XpathBuilder anyWhere() {
        return this.append("//");
    }

    public String build() {
        return this.xpath.toString();
    }

    private void appendTailSlashIfNotPresent() {
        if (!this.xpath.toString().endsWith("/")) {
            this.xpath.append("/");
        }
    }
}

