/*
 * Decompiled with CFR 0.152.
 */
package com.github.pellaton.springconfigvalidation;

import com.github.pellaton.springconfigvalidation.SpringConfigurationMessage;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class SpringConfigurationValidationProcessor
extends AbstractProcessor {
    private TypeElement autowiredTypeElement;
    private TypeElement beanTypeElement;
    private TypeElement bfppTypeElement;
    private TypeElement configurationTypeElement;
    private Messager messager;
    private Types typeUtils;
    private Elements elementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.autowiredTypeElement = this.elementUtils.getTypeElement("org.springframework.beans.factory.annotation.Autowired");
        this.beanTypeElement = this.elementUtils.getTypeElement("org.springframework.context.annotation.Bean");
        this.bfppTypeElement = this.elementUtils.getTypeElement("org.springframework.beans.factory.config.BeanFactoryPostProcessor");
        this.configurationTypeElement = this.elementUtils.getTypeElement("org.springframework.context.annotation.Configuration");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.errorRaised() && !roundEnv.processingOver()) {
            this.processRound(annotations, roundEnv);
        }
        return false;
    }

    private void processRound(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.processElement(element);
            }
        }
    }

    private void processElement(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element annotationTypeElement = annotationMirror.getAnnotationType().asElement();
            if (annotationTypeElement.equals(this.configurationTypeElement)) {
                List<? extends Element> enclosedElements = element.getEnclosedElements();
                this.processClass(element, ElementFilter.constructorsIn(enclosedElements));
                continue;
            }
            if (!annotationTypeElement.equals(this.beanTypeElement)) continue;
            this.processBeanMethod((ExecutableElement)element);
        }
    }

    private void processClass(Element element, List<ExecutableElement> constructors) {
        this.processClassVisibility(element);
        this.processConstructors(element, constructors);
        this.processStaticClass(element);
    }

    private void processStaticClass(Element element) {
        if (this.isNestedClass(element) && !this.isStaticMethod(element)) {
            this.printMessage(SpringConfigurationMessage.NESTED_CLASS_NOT_STATIC, element);
        }
    }

    private boolean isNestedClass(Element element) {
        return element.getEnclosingElement().getKind().equals((Object)ElementKind.CLASS);
    }

    private void processClassVisibility(Element element) {
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            this.printMessage(SpringConfigurationMessage.CLASS_FINAL, element);
        }
    }

    private void processConstructors(Element element, List<ExecutableElement> constructors) {
        boolean hasVisibleNoArgConsctructor = false;
        for (ExecutableElement constructor : constructors) {
            if (this.isVisibleElement(constructor) && this.hasNoParameter(constructor)) {
                hasVisibleNoArgConsctructor = true;
            }
            this.processAutowiredConstructor(constructor);
        }
        if (!hasVisibleNoArgConsctructor) {
            this.printMessage(SpringConfigurationMessage.MISSING_NO_ARG_CONSTRUCTOR, element);
        }
    }

    private void processAutowiredConstructor(ExecutableElement constructor) {
        List<? extends AnnotationMirror> annotations = constructor.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Element annotationTypeElement = annotationMirror.getAnnotationType().asElement();
            if (!annotationTypeElement.equals(this.autowiredTypeElement)) continue;
            this.printMessage(SpringConfigurationMessage.AUTOWIRED_CONSTRUCTOR, constructor, annotationMirror);
        }
    }

    private boolean hasNoParameter(ExecutableElement constructor) {
        return constructor.getParameters().isEmpty();
    }

    private boolean isVisibleElement(ExecutableElement constructor) {
        return !constructor.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    private void processBeanMethod(ExecutableElement methodElement) {
        this.processForScope(methodElement);
        this.processForFinal(methodElement);
        this.processForReturnType(methodElement);
        this.processForBFPP(methodElement);
        this.processForConfigurationClass(methodElement);
    }

    private void processForFinal(ExecutableElement methodElement) {
        if (this.isFinalMethod(methodElement)) {
            this.printMessage(SpringConfigurationMessage.BEAN_METHOD_FINAL, methodElement);
        }
    }

    private void processForReturnType(ExecutableElement methodElement) {
        if (methodElement.getReturnType().getKind() == TypeKind.VOID) {
            this.printMessage(SpringConfigurationMessage.BEAN_METHOD_RETURNS_VOID, methodElement);
        }
    }

    private void processForBFPP(ExecutableElement methodElement) {
        boolean implementsBFPP = this.typeUtils.isAssignable(methodElement.getReturnType(), this.bfppTypeElement.asType());
        boolean isStaticMethod = this.isStaticMethod(methodElement);
        if (isStaticMethod) {
            if (!implementsBFPP) {
                this.printMessage(SpringConfigurationMessage.STATIC_BEAN_METHOD, methodElement);
            }
        } else if (implementsBFPP) {
            this.printMessage(SpringConfigurationMessage.BFPP_BEAN_METHOD_NOT_STATIC, methodElement);
        }
    }

    private void processForConfigurationClass(ExecutableElement methodElement) {
        if (!this.isInConfigurationClass(methodElement)) {
            this.printMessage(SpringConfigurationMessage.BEAN_METHOD_NOT_IN_CONFIGURATION, methodElement);
        }
    }

    private void processForScope(Element methodElement) {
        if (this.isPrivateMethod(methodElement)) {
            this.printMessage(SpringConfigurationMessage.BEAN_METHOD_PRIVATE, methodElement);
        }
    }

    private boolean isPrivateMethod(Element methodElement) {
        return methodElement.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    private boolean isFinalMethod(Element methodElement) {
        return methodElement.getModifiers().contains((Object)Modifier.FINAL);
    }

    private boolean isStaticMethod(Element methodElement) {
        return methodElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isInConfigurationClass(ExecutableElement methodElement) {
        Element enclosingElement = methodElement.getEnclosingElement();
        List<? extends AnnotationMirror> annotationMirrors = enclosingElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!this.configurationTypeElement.equals(annotationType.asElement())) continue;
            return true;
        }
        return false;
    }

    private void printMessage(SpringConfigurationMessage message, Element element, AnnotationMirror annotationMirror) {
        this.messager.printMessage(message.getKind(), message.getMessage(), element, annotationMirror);
    }

    private void printMessage(SpringConfigurationMessage message, Element element) {
        this.printMessage(message, element, null);
    }
}

