/*
 * Decompiled with CFR 0.152.
 */
package sql.builder;

import java.util.ArrayList;
import java.util.List;
import sql.builder.Aliased;
import sql.builder.ISql;
import sql.builder.condition.Condition;
import sql.builder.join.Join;
import sql.select.Select;

public class SqlBuilder
implements ISql {
    private List<Select> select = new ArrayList<Select>();
    private List<Aliased> from = new ArrayList<Aliased>();
    private List<Join> join = new ArrayList<Join>();
    private List<Condition> where = new ArrayList<Condition>();
    private List<String> groupBy = new ArrayList<String>();
    private List<String> orderBy = new ArrayList<String>();

    public void select(Select select) {
        this.select.add(select);
    }

    public void from(Aliased aliased) {
        this.from.add(aliased);
    }

    public void join(Join join) {
        this.join.add(join);
    }

    public void groupBy(String expression) {
        this.groupBy.add(expression);
    }

    public void orderBy(String expression) {
        this.orderBy.add(expression);
    }

    @Override
    public String sql() {
        String sql = "SELECT " + this.join(", ", this.select) + " ";
        sql = sql + "FROM " + this.join(", ", this.from);
        if (!this.join.isEmpty()) {
            sql = sql + " " + this.join(" ", this.join);
        }
        if (!this.where.isEmpty()) {
            sql = sql + " WHERE " + this.join(" AND ", this.where);
        }
        if (!this.groupBy.isEmpty()) {
            sql = sql + " GROUP BY " + this.join(this.groupBy, ", ");
        }
        if (!this.orderBy.isEmpty()) {
            sql = sql + " ORDER BY " + this.join(this.orderBy, ", ");
        }
        return sql;
    }

    protected String join(List<String> list, String seprarator) {
        return String.join((CharSequence)seprarator, list);
    }

    protected <T extends ISql> String join(String separator, List<T> list) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (ISql obj : list) {
            stringList.add(obj.sql());
        }
        return String.join((CharSequence)separator, stringList);
    }
}

