/*
 * Decompiled with CFR 0.152.
 */
package sql.builder.condition.strings;

import sql.builder.condition.Condition;

public class StringCondition
implements Condition {
    private String property;
    private String value;

    protected StringCondition(String property, String value) {
        this.property = property;
        this.value = value;
    }

    @Override
    public String sql() {
        return this.property + " LIKE " + this.value;
    }

    public static StringCondition like(String property, String value) {
        return new StringCondition(property, "'%" + value + "%'");
    }

    public static StringCondition startsWith(String property, String value) {
        return new StringCondition(property, "'" + value + "%'");
    }

    public static StringCondition endsWith(String property, String value) {
        return new StringCondition(property, "'%" + value + "'");
    }
}

