/*
 * Decompiled with CFR 0.152.
 */
package sql.builder.join;

import sql.builder.Aliased;
import sql.builder.condition.Condition;
import sql.builder.join.JoinType;

public class Join
extends Aliased {
    private JoinType joinType;
    private Condition condition;

    protected Join(String property, String alias, Condition condition, JoinType joinType) {
        super(property, alias);
        this.condition = condition;
        this.joinType = joinType;
    }

    public Join(String property, Condition condition, JoinType joinType) {
        this(property, null, condition, joinType);
    }

    @Override
    public String sql() {
        return this.joinType.sql() + " " + super.sql() + " ON " + this.condition.sql();
    }

    public static Join left(String property, Condition condition) {
        return new Join(property, condition, JoinType.LEFT_JOIN);
    }

    public static Join left(String property, String alias, Condition condition) {
        return new Join(property, alias, condition, JoinType.LEFT_JOIN);
    }

    public static Join right(String property, Condition condition) {
        return new Join(property, condition, JoinType.RIGHT_JOIN);
    }

    public static Join right(String property, String alias, Condition condition) {
        return new Join(property, alias, condition, JoinType.RIGHT_JOIN);
    }
}

