/*
 * Decompiled with CFR 0.152.
 */
package sql.select;

import org.hibernate.type.BigDecimalType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import sql.select.Select;

public class SelectPercentage
extends Select {
    public SelectPercentage(String divident, String divisor, String alias) {
        this(divident, divisor, 2, false, alias);
    }

    public SelectPercentage(String divident, String divisor, int precision, boolean showPercentageSymbol, String alias) {
        super(SelectPercentage.getSqlStatement(divident, divisor, precision, showPercentageSymbol), alias, (Type)(showPercentageSymbol ? StringType.INSTANCE : BigDecimalType.INSTANCE));
    }

    protected static String getSqlStatement(String divident, String divisor, int precision, boolean showPercentageSymbol) {
        String expression = "CASE WHEN " + divisor + "=0 THEN 0 ELSE ROUND((100*" + divident + "/" + divisor + "), " + precision + ")";
        if (showPercentageSymbol) {
            expression = "TO_CHAR(" + expression + ") || '%'";
        }
        return expression;
    }
}

