/*
 * Decompiled with CFR 0.152.
 */
package com.github.pheymann.mockitjavaapi.core;

import com.github.pheymann.mockit.core.BasicMockType;
import com.github.pheymann.mockit.core.ConnectionType;
import com.github.pheymann.mockit.core.FaultLevel;
import com.github.pheymann.mockit.core.FixedDelay;
import com.github.pheymann.mockit.core.LooseConnection;
import com.github.pheymann.mockit.core.LooseResponse;
import com.github.pheymann.mockit.core.MultipleResponses;
import com.github.pheymann.mockit.core.NoFault;
import com.github.pheymann.mockit.logging.LogEntry;
import com.github.pheymann.mockitjavaapi.General;
import com.github.pheymann.mockitjavaapi.core.JFaultLevelData;
import com.github.pheymann.mockitjavaapi.core.JMockResult;
import java.util.ArrayList;
import java.util.List;
import scala.Enumeration;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ListBuffer;

public class ConvertUtil {
    public static Enumeration.Value javaToScala(General.JBasicMockType jBasicType) {
        if (jBasicType.equals((Object)General.JBasicMockType.client)) {
            return BasicMockType.client();
        }
        if (jBasicType.equals((Object)General.JBasicMockType.server)) {
            return BasicMockType.server();
        }
        if (jBasicType.equals((Object)General.JBasicMockType.agent)) {
            return BasicMockType.agent();
        }
        if (jBasicType.equals((Object)General.JBasicMockType.p2p)) {
            return BasicMockType.p2p();
        }
        if (jBasicType.equals((Object)General.JBasicMockType.none)) {
            return BasicMockType.none();
        }
        return BasicMockType.none();
    }

    public static Enumeration.Value javaToScala(General.JConnectionType jConType) {
        if (jConType.equals((Object)General.JConnectionType.tcp)) {
            return ConnectionType.tcp();
        }
        if (jConType.equals((Object)General.JConnectionType.udp)) {
            return ConnectionType.udp();
        }
        if (jConType.equals((Object)General.JConnectionType.http)) {
            return ConnectionType.http();
        }
        if (jConType.equals((Object)General.JConnectionType.none)) {
            return ConnectionType.none();
        }
        return ConnectionType.none();
    }

    public static FaultLevel javaToScala(General.JFaultLevel jFault, JFaultLevelData jData) throws IllegalArgumentException {
        if (jFault.equals((Object)General.JFaultLevel.noFault)) {
            return new NoFault();
        }
        if (jFault.equals((Object)General.JFaultLevel.fixedDelay)) {
            return new FixedDelay(jData.getTime());
        }
        if (jFault.equals((Object)General.JFaultLevel.looseResponse)) {
            return new LooseResponse();
        }
        if (jFault.equals((Object)General.JFaultLevel.looseConnection)) {
            return new LooseConnection();
        }
        if (jFault.equals((Object)General.JFaultLevel.multipleResponses)) {
            return new MultipleResponses(jData.getFactor());
        }
        throw new IllegalArgumentException("no valid fault level");
    }

    public static Tuple2<byte[], FaultLevel> javaToScala(JMockResult result) {
        return new Tuple2((Object)result.getResponse(), (Object)ConvertUtil.javaToScala(result.getFault(), result.getData()));
    }

    public static List<LogEntry> scalaToJava(ListBuffer<LogEntry> logs) {
        Iterator iterator = logs.iterator();
        ArrayList<LogEntry> results = new ArrayList<LogEntry>();
        while (iterator.hasNext()) {
            results.add((LogEntry)iterator.next());
        }
        return results;
    }
}

