/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.control;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.commands.SystemOfUnits;
import com.github.pires.obd.enums.AvailableCommandNames;

public class DistanceMILOnCommand
extends ObdCommand
implements SystemOfUnits {
    private int km = 0;

    public DistanceMILOnCommand() {
        super("01 21");
    }

    public DistanceMILOnCommand(DistanceMILOnCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        this.km = (Integer)this.buffer.get(2) * 256 + (Integer)this.buffer.get(3);
    }

    @Override
    public String getFormattedResult() {
        return this.useImperialUnits ? String.format("%.2f%s", Float.valueOf(this.getImperialUnit()), this.getResultUnit()) : String.format("%d%s", this.km, this.getResultUnit());
    }

    @Override
    public String getCalculatedResult() {
        return this.useImperialUnits ? String.valueOf(this.getImperialUnit()) : String.valueOf(this.km);
    }

    @Override
    public String getResultUnit() {
        return this.useImperialUnits ? "m" : "km";
    }

    @Override
    public float getImperialUnit() {
        return (float)this.km * 0.6213712f;
    }

    public int getKm() {
        return this.km;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.DISTANCE_TRAVELED_MIL_ON.getValue();
    }
}

