/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.enums;

import java.util.HashMap;
import java.util.Map;

public enum FuelType {
    GASOLINE(1, "Gasoline"),
    METHANOL(2, "Methanol"),
    ETHANOL(3, "Ethanol"),
    DIESEL(4, "Diesel"),
    LPG(5, "GPL/LGP"),
    CNG(6, "Natural Gas"),
    PROPANE(7, "Propane"),
    ELECTRIC(8, "Electric"),
    BIFUEL_GASOLINE(9, "Biodiesel + Gasoline"),
    BIFUEL_METHANOL(10, "Biodiesel + Methanol"),
    BIFUEL_ETHANOL(11, "Biodiesel + Ethanol"),
    BIFUEL_LPG(12, "Biodiesel + GPL/LGP"),
    BIFUEL_CNG(13, "Biodiesel + Natural Gas"),
    BIFUEL_PROPANE(14, "Biodiesel + Propane"),
    BIFUEL_ELECTRIC(15, "Biodiesel + Electric"),
    BIFUEL_GASOLINE_ELECTRIC(16, "Biodiesel + Gasoline/Electric"),
    HYBRID_GASOLINE(17, "Hybrid Gasoline"),
    HYBRID_ETHANOL(18, "Hybrid Ethanol"),
    HYBRID_DIESEL(19, "Hybrid Diesel"),
    HYBRID_ELECTRIC(20, "Hybrid Electric"),
    HYBRID_MIXED(21, "Hybrid Mixed"),
    HYBRID_REGENERATIVE(22, "Hybrid Regenerative");

    private static Map<Integer, FuelType> map;
    private final int value;
    private final String description;

    private FuelType(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public static FuelType fromValue(int value) {
        return map.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        map = new HashMap<Integer, FuelType>();
        for (FuelType error : FuelType.values()) {
            map.put(error.getValue(), error);
        }
    }
}

