/*
 * Decompiled with CFR 0.152.
 */
package com.github.rameshl.appengine.test;

import com.github.rameshl.appengine.test.GaeTestConfigType;
import com.github.rameshl.appengine.test.UserInfo;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.testing.LocalDatastoreServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalMemcacheServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.appengine.tools.development.testing.LocalTaskQueueTestConfig;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.ObjectifyService;
import com.googlecode.objectify.util.Closeable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import lombok.Generated;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class AppEngineRule
extends ExternalResource {
    private final Map<GaeTestConfigType, LocalServiceTestConfig> configs;
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private LocalServiceTestHelper helper;
    private UserInfo userInfo;
    private Clock clock;
    private String generatedDirPath;
    private Closeable session;

    public AppEngineRule(Map<GaeTestConfigType, LocalServiceTestConfig> configs) {
        this.configs = configs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Statement apply(Statement base, Description description) {
        return RuleChain.outerRule((TestRule)this.temporaryFolder).around(new TestRule(){

            public Statement apply(Statement base, Description description) {
                return AppEngineRule.super.apply(base, null);
            }
        }).apply(base, description);
    }

    protected void before() {
        this.helper = new LocalServiceTestHelper(this.configs.values().toArray(new LocalServiceTestConfig[0]));
        if (this.userInfo != null) {
            this.helper.setEnvIsLoggedIn(this.userInfo.isLoggedIn()).setEnvIsAdmin(this.userInfo.isAdmin()).setEnvAuthDomain(this.userInfo.getAuthDomain()).setEnvEmail(this.userInfo.getEmail()).setEnvAttributes((Map)ImmutableMap.of((Object)"com.google.appengine.api.users.UserService.user_id_key", (Object)this.userInfo.getUserId()));
        }
        this.helper.setClock(this.clock);
        this.helper.setUp();
        if (this.configs.containsKey((Object)GaeTestConfigType.Datastore)) {
            if (this.generatedDirPath == null) {
                this.generatedDirPath = this.temporaryFolder.getRoot().getAbsolutePath();
            }
            System.setProperty("appengine.generated.dir", this.generatedDirPath);
            this.session = ObjectifyService.begin();
        }
    }

    protected void after() {
        this.helper.tearDown();
        this.helper = null;
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void registerEntity(Class<?> ... classes) {
        if (!this.configs.containsKey((Object)GaeTestConfigType.Datastore)) {
            throw new IllegalArgumentException("datastore service not initialized");
        }
        ObjectifyFactory factory = ObjectifyService.factory();
        for (Class<?> clazz : classes) {
            factory.register(clazz);
        }
    }

    public File getGeneratedAutoIndexes() {
        File file = new File(this.generatedDirPath, "datastore-indexes-auto.xml");
        return file.exists() ? file : null;
    }

    public void setupLogging(Class<?> context, String fileName) throws IOException {
        URL url = context == null ? Resources.getResource((String)fileName) : Resources.getResource(context, (String)"logging.properties");
        String logging = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(logging.getBytes(Charsets.UTF_8)));
    }

    @Generated
    public Map<GaeTestConfigType, LocalServiceTestConfig> getConfigs() {
        return this.configs;
    }

    @Generated
    public TemporaryFolder getTemporaryFolder() {
        return this.temporaryFolder;
    }

    @Generated
    public LocalServiceTestHelper getHelper() {
        return this.helper;
    }

    @Generated
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public String getGeneratedDirPath() {
        return this.generatedDirPath;
    }

    @Generated
    public Closeable getSession() {
        return this.session;
    }

    @Generated
    public void setHelper(LocalServiceTestHelper helper) {
        this.helper = helper;
    }

    @Generated
    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @Generated
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Generated
    public void setGeneratedDirPath(String generatedDirPath) {
        this.generatedDirPath = generatedDirPath;
    }

    @Generated
    public void setSession(Closeable session) {
        this.session = session;
    }

    @Generated
    public String toString() {
        return "AppEngineRule(configs=" + this.getConfigs() + ", temporaryFolder=" + this.getTemporaryFolder() + ", helper=" + this.getHelper() + ", userInfo=" + this.getUserInfo() + ", clock=" + this.getClock() + ", generatedDirPath=" + this.getGeneratedDirPath() + ", session=" + this.getSession() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppEngineRule)) {
            return false;
        }
        AppEngineRule other = (AppEngineRule)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map<GaeTestConfigType, LocalServiceTestConfig> this$configs = this.getConfigs();
        Map<GaeTestConfigType, LocalServiceTestConfig> other$configs = other.getConfigs();
        if (this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs)) {
            return false;
        }
        TemporaryFolder this$temporaryFolder = this.getTemporaryFolder();
        TemporaryFolder other$temporaryFolder = other.getTemporaryFolder();
        if (this$temporaryFolder == null ? other$temporaryFolder != null : !this$temporaryFolder.equals(other$temporaryFolder)) {
            return false;
        }
        LocalServiceTestHelper this$helper = this.getHelper();
        LocalServiceTestHelper other$helper = other.getHelper();
        if (this$helper == null ? other$helper != null : !this$helper.equals(other$helper)) {
            return false;
        }
        UserInfo this$userInfo = this.getUserInfo();
        UserInfo other$userInfo = other.getUserInfo();
        if (this$userInfo == null ? other$userInfo != null : !((Object)this$userInfo).equals(other$userInfo)) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        if (this$clock == null ? other$clock != null : !this$clock.equals(other$clock)) {
            return false;
        }
        String this$generatedDirPath = this.getGeneratedDirPath();
        String other$generatedDirPath = other.getGeneratedDirPath();
        if (this$generatedDirPath == null ? other$generatedDirPath != null : !this$generatedDirPath.equals(other$generatedDirPath)) {
            return false;
        }
        Closeable this$session = this.getSession();
        Closeable other$session = other.getSession();
        return !(this$session == null ? other$session != null : !this$session.equals(other$session));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AppEngineRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<GaeTestConfigType, LocalServiceTestConfig> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        TemporaryFolder $temporaryFolder = this.getTemporaryFolder();
        result = result * 59 + ($temporaryFolder == null ? 43 : $temporaryFolder.hashCode());
        LocalServiceTestHelper $helper = this.getHelper();
        result = result * 59 + ($helper == null ? 43 : $helper.hashCode());
        UserInfo $userInfo = this.getUserInfo();
        result = result * 59 + ($userInfo == null ? 43 : ((Object)$userInfo).hashCode());
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : $clock.hashCode());
        String $generatedDirPath = this.getGeneratedDirPath();
        result = result * 59 + ($generatedDirPath == null ? 43 : $generatedDirPath.hashCode());
        Closeable $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        return result;
    }

    public static class Builder {
        private Map<GaeTestConfigType, LocalServiceTestConfig> configs = new HashMap<GaeTestConfigType, LocalServiceTestConfig>();
        private UserInfo userInfo;
        private Clock clock;
        private String generatedDirPath;

        public Builder withAll() {
            return this.withTypes(GaeTestConfigType.values());
        }

        public Builder withTypes(GaeTestConfigType ... types) {
            for (GaeTestConfigType type : types) {
                this.withType(type);
            }
            return this;
        }

        public Builder withType(GaeTestConfigType type) {
            this.configs.put(type, type.getConfig());
            return this;
        }

        public Builder withDatastore() {
            return this.withTypes(GaeTestConfigType.Datastore);
        }

        public Builder withDatastore(LocalDatastoreServiceTestConfig config) {
            this.configs.put(GaeTestConfigType.Datastore, (LocalServiceTestConfig)config);
            return this;
        }

        public Builder withQueue() {
            return this.withTypes(GaeTestConfigType.Queue);
        }

        public Builder withQueue(String queueXmlPath) {
            LocalTaskQueueTestConfig config = GaeTestConfigType.queueConfig();
            config.setQueueXmlPath(queueXmlPath);
            return this.withQueue(config);
        }

        public Builder withQueue(LocalTaskQueueTestConfig config) {
            this.configs.put(GaeTestConfigType.Queue, (LocalServiceTestConfig)config);
            return this;
        }

        public Builder withMemcache() {
            return this.withTypes(GaeTestConfigType.Memcache);
        }

        public Builder withMemcache(LocalMemcacheServiceTestConfig config) {
            this.configs.put(GaeTestConfigType.Memcache, (LocalServiceTestConfig)config);
            return this;
        }

        public Builder withUrlFetcher() {
            return this.withTypes(GaeTestConfigType.UrlFetch);
        }

        public Builder withUserService(UserInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withGeneratedDirPath(String dirPath) {
            this.generatedDirPath = dirPath;
            return this;
        }

        public AppEngineRule build() {
            AppEngineRule rule = new AppEngineRule(this.configs);
            rule.setClock(this.clock);
            rule.setUserInfo(this.userInfo);
            rule.setGeneratedDirPath(this.generatedDirPath);
            return rule;
        }
    }
}

