package com.github.rameshdev.httputils;

import lombok.Builder;
import lombok.Data;

/**
 * The type Fetch config.
 */
@Data
@Builder(builderClassName = "Builder")
public class FetchConfig {

    /**
     * The Follow redirects.
     */
    @lombok.Builder.Default
    protected boolean followRedirects = false;

    /**
     * The Connection time out secs.
     */
    protected int connectionTimeOutSecs;

    /**
     * With defaults fetch config.
     *
     * @return the fetch config
     */
    public static FetchConfig withDefaults() {
        return FetchConfig.builder().build();
    }
}
