package com.github.rameshdev.httputils;

import java.util.List;
import java.util.Map;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The type Http response.
 */
@Data
@NoArgsConstructor
public class HttpResponse {

    private int statusCode;

    private String responseContent;

    private Map<String, List<String>> headers;

    /**
     * Instantiates a new Http response.
     *
     * @param statusCode      the status code
     * @param responseContent the response content
     */
    public HttpResponse(int statusCode, String responseContent) {
        this.statusCode = statusCode;
        this.responseContent = responseContent;
    }

    /**
     * returns true when the status code is between 200 - 299, false otherwise
     *
     * @return the boolean
     */
    public boolean wasSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }
}
