package com.github.rameshdev.httputils;

/**
 * The enum Media type.
 */
public enum MediaType {

    /**
     * Json media type.
     */
    JSON("application/json");

    private final String contentType;

    MediaType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Gets content type.
     *
     * @return the content type
     */
    public String getContentType() {
        return contentType;
    }
}
