package com.hujiang.ndkp;

import android.util.Log;

/**
 * Created by rarnu on 7/4/17.
 */
public class CrossServer {

    static {
        try {
            System.loadLibrary("crossserver");
        } catch (Throwable th) {
            Log.e("ScriptShell", "System.loadLibrary(\"crossserver\") => " + th.getMessage());
        }
    }

    /**
     * 开启一个本地服务器
     * @param port 监听端口号
     * @param fileLocation 文件路径
     * @param scriptFile 脚本文件
     * @return 是否开启成功
     */
    public static native boolean startServer(int port, String fileLocation, String scriptFile);

    /**
     * 停止本地服务器
     * @return 是否停止成功
     */
    public static native boolean stopServer();

}
