package com.hujiang.ndkp;

import android.util.Log;

import java.util.List;

/**
 * Created by rarnu on 7/4/17.
 */
public class ScriptShell {

    static {
        try {
            System.loadLibrary("scriptshell");
        } catch (Throwable th) {
            Log.e("ScriptShell", "System.loadLibrary(\"scriptshell\") => " + th.getMessage());
        }
    }

    /**
     * 注册回调类，注册后全部的脚本回调均通过该类返回<br/>
     * 回调类必须包含以下方法：<br/>
     * public String scriptHost(int id, String param1, String param2, String param3)<br/>
     * public void scriptRunLine(int id, String unitName, String srcPos)<br/>
     * public void writeln(int id, String str)<br/>
     * @param pkgName 包名，如com.hujiang.ndkp
     * @param clsName 类名，如scriptcallback
     */
    public static native void registerComponentName(String pkgName, String clsName);

    /**
     * 加载原生插件
     * @param basePath 插件所在的路径
     */
    @Deprecated
    public static native void loadNativePlugin(String basePath);

    /**
     * 加载一个未经编译的脚本源码文件
     * @param filePath 文件路径
     * @return 脚本ID，加载失败返回-1
     */
    public static native int addScriptFile(String filePath);

    /**
     * 加载一个脚本源码字符串
     * @param text 源码字符串
     * @return 脚本ID，加载失败返回-1
     */
    public static native int addScriptText(String text);

    /**
     * 加载一个经过编译的脚本文件
     * @param filePath 文件路径
     * @return 脚本ID，加载失败返回-1
     */
    public static native int addScriptBinary(String filePath);

    /**
     * 添加一个引用路径，该路径指出了脚本代码中的 include/import/uses 相关标记所能够查找的代码目录
     * @param id 脚本ID
     * @param path 引用路径（纯路径，不包含文件名）
     */
    public static native void addIncludePath(int id, String path);

    /**
     * 设置是否允许按行中断，允许的情况下，即是调试开启的状态
     * @param id 脚本ID
     * @param canInterrupt 是否允许
     */
    public static native void setRunLineInterrupt(int id, boolean canInterrupt);

    /**
     * 移除脚本
     * @param id 脚本ID
     * @return 是否移除成功
     */
    public static native boolean removeScript(int id);

    /**
     * 执行脚本
     * @param id 脚本ID
     * @return 是否执行成功
     */
    public static native boolean runScript(int id);

    /**
     * 执行脚本中的特定函数
     * @param id 脚本ID
     * @param AMethodName 函数名
     * @param AParamTypes 参数类型表，参数类型表支持以下类型（i:int, s:string, b:boolean, d:double, l:long, 若是数组则在类型前加a），类型之间用逗号分隔，最后以逗号结尾，如 "s,i,ai,"，该字符串表明了三个参数分别为字符串，整型与整型数组
     * @param AParams 参数值表，全部参数均需要先转换成字符串，如 new String[] { "a", "1", "[1,2,3]"}
     * @return 函数的返回值，若是void函数返回空字符串
     */
    public static native String callMethod(int id, String AMethodName, String AParamTypes, String[] AParams);

    /**
     * 执行脚本中的特定函数
     * @param id 脚本ID
     * @param AMethodName 函数名
     * @param AparamTypes 参数类型表，参数类型表支持以下类型（i:int, s:string, b:boolean, d:double, l:long, 若是数组则在类型前加a），类型之间用逗号分隔，最后以逗号结尾，如 "s,i,ai,"，该字符串表明了三个参数分别为字符串，整型与整型数组
     * @param AParams 参数值表，以json形式组织，如 ["a", 1, [1,2,3]]
     * @return 函数的返回值，若是void函数返回空字符串
     */
    public static native String callMethod2(int id, String AMethodName, String AparamTypes, String AParams);

    /**
     * 强制停止一个脚本，通常用于在脚本未执行完时强行停止，如在产生死循环的状态下中断
     * @param id 脚本ID
     * @return 是否停止成功
     */
    public static native boolean stopScript(int id);

    /**
     * 获取运行时错误，仅当 runScript 方法返回 false 时可以调用
     * @param id 脚本ID
     * @return 错误信息
     */
    public static native String getErrorMessage(int id);

    /**
     * 计算一个表达式的值（可以在运行时调用，以实现断点调试时的表达式获取）
     * @param id 脚本ID
     * @param avar 表达式，可以是变量名，函数调用
     * @return 值
     */
    public static native String evoluateScriptVariable(int id, String avar);

    /**
     * 对脚本进行分析，解析其中的变量与方法成员
     * @param id 脚本ID
     * @return 分析结果json字符串
     */
    public static native String analysisScript(int id);

    /**
     * 编译一个脚本源码文件
     * @param codePath 源码文件路径
     * @param destPath 目标文件路径
     * @param includePath 编译时引用路径，该路径指出了脚本代码中的 include/import/uses 相关标记所能够查找的代码目录
     * @return 是否编译成功
     */
    public static native boolean compile(String codePath, String destPath, String includePath);

    /**
     * 获取编译时错误，仅当 compile 方法返回 false 时可以调用
     * @return 错误信息
     */
    public static native String getCompileError();

    /**
     * 设置是否允许 AOP
     * @param AEnabled 是否允许
     */
    public static native void setAOPEnabled(boolean AEnabled);

    /**
     * 获取 AOP 是否允许
     * @return 是否允许
     */
    public static native boolean getAOPEnabled();

}
