/*
 * Decompiled with CFR 0.152.
 */
package com.buck.common.codec;

import com.buck.common.codec.Codec;
import com.buck.common.codec.CodecDecoder;
import com.buck.common.codec.CodecEncoder;
import com.buck.common.codec.StandardCodecs;

public class Base16
extends Codec {
    private static final byte[] base16Alphabet;
    private static final byte[] base16DecodeTable;

    public Base16() {
        super("base16", StandardCodecs.aliases_Base16);
    }

    @Override
    public CodecDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CodecEncoder newEncoder() {
        return new Encoder(this);
    }

    static {
        int i;
        base16Alphabet = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        base16DecodeTable = new byte[128];
        for (i = 0; i < base16DecodeTable.length; ++i) {
            Base16.base16DecodeTable[i] = -1;
        }
        for (i = 0; i < base16Alphabet.length; ++i) {
            Base16.base16DecodeTable[Base16.base16Alphabet[i]] = (byte)i;
        }
    }

    private static class Encoder
    extends CodecEncoder {
        public Encoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] encode(byte[] bytes) {
            int size = bytes.length;
            byte[] encoded = new byte[size * 2];
            int caIdx = 0;
            for (int baIdx = 0; baIdx < size; ++baIdx) {
                encoded[caIdx++] = base16Alphabet[bytes[baIdx] >> 4 & 0xF];
                encoded[caIdx++] = base16Alphabet[bytes[baIdx] & 0xF];
            }
            return encoded;
        }
    }

    private static class Decoder
    extends CodecDecoder {
        public Decoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] decode(byte[] encoded) {
            int size = encoded.length;
            byte[] decoded = new byte[size / 2];
            int baIdx = 0;
            int caIdx = 0;
            while (caIdx < size) {
                byte c0 = base16DecodeTable[encoded[caIdx++]];
                byte c1 = base16DecodeTable[encoded[caIdx++]];
                decoded[baIdx++] = (byte)(c0 << 4 | c1);
            }
            return decoded;
        }
    }
}

