/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.viewmodels;

import io.reactivesprint.Preconditions;
import io.reactivesprint.rx.IMutableProperty;
import io.reactivesprint.rx.IProperty;
import io.reactivesprint.rx.MutableProperty;
import io.reactivesprint.rx.Property;
import io.reactivesprint.rx.functions.Func1Comparable;
import io.reactivesprint.viewmodels.IArrayViewModel;
import io.reactivesprint.viewmodels.IViewModel;
import io.reactivesprint.viewmodels.ViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ArrayViewModel<E extends IViewModel>
extends ViewModel
implements IArrayViewModel<E> {
    private final Object lock = new Object();
    private final IMutableProperty<Integer> count = new MutableProperty<Integer>(0);
    private final IProperty<Boolean> empty;
    private List<E> viewModels;
    private final IMutableProperty<CharSequence> localizedEmptyMessage = new MutableProperty<Object>(null);

    protected ArrayViewModel() {
        this.empty = new Property<Boolean>((Integer)this.count.getValue() <= 0, this.count.getObservable().skip(1).distinctUntilChanged().map(new Func1Comparable<Integer>(-2, 0)));
    }

    public ArrayViewModel(Collection<E> viewModels) {
        this();
        Preconditions.checkNotNull(viewModels, "viewModels");
        this.setViewModels(viewModels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<E> iterator() {
        Object object = this.lock;
        synchronized (object) {
            return this.viewModels.iterator();
        }
    }

    @Override
    public final IProperty<Integer> count() {
        return this.count;
    }

    @Override
    public final IProperty<Boolean> empty() {
        return this.empty;
    }

    public IMutableProperty<CharSequence> localizedEmptyMessage() {
        return this.localizedEmptyMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setViewModels(Collection<E> viewModels) {
        if (viewModels == null) {
            viewModels = Collections.emptyList();
        }
        Object object = this.lock;
        synchronized (object) {
            this.viewModels = new ArrayList<E>(viewModels);
            this.count.setValue(this.viewModels.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<E> getViewModels() {
        Object object = this.lock;
        synchronized (object) {
            return this.viewModels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int indexOf(E element) {
        Preconditions.checkNotNull(element, "element");
        Object object = this.lock;
        synchronized (object) {
            return this.viewModels.indexOf(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E getViewModel(int index) {
        Object object = this.lock;
        synchronized (object) {
            return (E)((IViewModel)this.viewModels.get(index));
        }
    }
}

