/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.views;

import io.reactivesprint.viewmodels.IFetchedArrayViewModel;
import io.reactivesprint.viewmodels.IViewModel;
import io.reactivesprint.views.ArrayViewBinder;
import io.reactivesprint.views.IFetchedArrayView;
import io.reactivesprint.views.IFetchedArrayViewBinder;
import io.reactivesprint.views.ILifecycleProvider;
import io.reactivesprint.views.Views;
import rx.Subscription;
import rx.internal.util.SubscriptionList;

public class FetchedArrayViewBinder<E extends IViewModel, VM extends IFetchedArrayViewModel<E, ?, ?, ?>>
extends ArrayViewBinder<E, VM>
implements IFetchedArrayViewBinder<E, VM> {
    public FetchedArrayViewBinder(IFetchedArrayView<E, VM> view, ILifecycleProvider<?> lifecycleProvider) {
        super(view, lifecycleProvider);
    }

    @Override
    public IFetchedArrayView<E, VM> getView() {
        return (IFetchedArrayView)super.getView();
    }

    @Override
    protected SubscriptionList bindViewModel() {
        SubscriptionList subscription = super.bindViewModel();
        IFetchedArrayViewModel arrayViewModel = (IFetchedArrayViewModel)this.getView().getViewModel();
        if (arrayViewModel == null) {
            return null;
        }
        if (subscription == null) {
            subscription = new SubscriptionList();
        }
        subscription.add(this.bindRefreshing(arrayViewModel));
        subscription.add(this.bindFetchingNextPage(arrayViewModel));
        return subscription;
    }

    @Override
    public Subscription bindRefreshing(VM arrayViewModel) {
        return arrayViewModel.refreshing().getObservable().compose(this.bindToLifecycle()).subscribe(Views.presentRefreshing(this.getView()));
    }

    @Override
    public Subscription bindFetchingNextPage(VM arrayViewModel) {
        return arrayViewModel.fetchingNextPage().getObservable().compose(this.bindToLifecycle()).subscribe(Views.presentFetchingNextPage(this.getView()));
    }
}

