/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.viewmodels;

import io.reactivesprint.Preconditions;
import io.reactivesprint.rx.ICommand;
import io.reactivesprint.rx.IMutableProperty;
import io.reactivesprint.rx.IProperty;
import io.reactivesprint.rx.MutableProperty;
import io.reactivesprint.rx.Property;
import io.reactivesprint.rx.functions.Func1BooleanNot;
import io.reactivesprint.rx.functions.FuncNBooleanOr;
import io.reactivesprint.viewmodels.IViewModel;
import io.reactivesprint.viewmodels.IViewModelException;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.subjects.PublishSubject;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;

public class ViewModel
implements IViewModel {
    private final IMutableProperty<Boolean> active = new MutableProperty<Boolean>(false);
    private final IMutableProperty<CharSequence> title = new MutableProperty<Object>(null);
    private final Subject<Observable<Boolean>, Observable<Boolean>> loadingSubject = PublishSubject.create();
    private final IProperty<Boolean> loading;
    private final IProperty<Boolean> enabled;
    private final Subject<Observable<IViewModelException>, Observable<IViewModelException>> errorsSubject = ReplaySubject.create((int)1);
    private final Observable<IViewModelException> errors = Observable.merge(this.errorsSubject);

    public ViewModel() {
        Observable loadingObservable = Observable.switchOnNext((Observable)this.loadingSubject.scan((Object)Observable.just((Object)false), (Func2)new Func2<Observable<Boolean>, Observable<Boolean>, Observable<Boolean>>(){

            public Observable<Boolean> call(Observable<Boolean> observable, Observable<Boolean> observable2) {
                return Observable.combineLatest(observable, (Observable)observable2.startWith((Object)false), (Func2)FuncNBooleanOr.getInstance());
            }
        }));
        this.loading = new Property<Boolean>(false, loadingObservable);
        this.enabled = new Property<Boolean>(false, this.loading.getObservable().map((Func1)Func1BooleanNot.getInstance()));
    }

    public ViewModel(String title) {
        this();
        this.title.setValue(title);
    }

    @Override
    public final IMutableProperty<Boolean> active() {
        return this.active;
    }

    public IMutableProperty<CharSequence> title() {
        return this.title;
    }

    @Override
    public final IProperty<Boolean> loading() {
        return this.loading;
    }

    @Override
    public final Observable<IViewModelException> errors() {
        return this.errors;
    }

    @Override
    public final IProperty<Boolean> enabled() {
        return this.enabled;
    }

    @Override
    public final void bindLoading(Observable<Boolean> loadingObservable) {
        Preconditions.checkNotNull(loadingObservable, "loadingObservable");
        this.loadingSubject.onNext((Object)loadingObservable.concatWith(Observable.just((Object)false)).onErrorResumeNext(Observable.just((Object)false)));
    }

    @Override
    public final void bindErrors(Observable<IViewModelException> errorObservable) {
        Preconditions.checkNotNull(errorObservable, "errorObservable");
        this.errorsSubject.onNext((Object)errorObservable.onErrorResumeNext(Observable.empty()));
    }

    @Override
    public final <I, R> void bindCommand(ICommand<I, R> command) {
        Preconditions.checkNotNull(command, "command");
        this.bindLoading(command.isExecuting().getObservable());
        this.bindErrors((Observable<IViewModelException>)command.getErrors().flatMap((Func1)new Func1<Throwable, Observable<IViewModelException>>(){

            public Observable<IViewModelException> call(Throwable throwable) {
                if (throwable instanceof IViewModelException) {
                    return Observable.just((Object)((IViewModelException)((Object)throwable)));
                }
                return Observable.empty();
            }
        }));
    }

    public String toString() {
        return "ViewModel{active=" + this.active.getValue() + ", title=" + this.title.getValue() + ", loading=" + this.loading.getValue() + ", enabled=" + this.enabled.getValue() + '}';
    }
}

