/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.views;

import io.reactivesprint.Preconditions;
import io.reactivesprint.views.ILifecycleProvider;
import rx.Observable;
import rx.functions.Func1;

public final class LifecycleProviders {
    private LifecycleProviders() {
    }

    public static <E> ILifecycleProvider<E> from(final Observable<E> lifecycle, final E startEvent, final E stopEvent) {
        Preconditions.checkNotNull(lifecycle, "lifecycle");
        Preconditions.checkNotNull(startEvent, "startEvent");
        Preconditions.checkNotNull(stopEvent, "stopEvent");
        return new ILifecycleProvider<E>(){

            @Override
            public Observable<E> onStartBinding() {
                return lifecycle.distinctUntilChanged().filter(new Func1<E, Boolean>(){

                    public Boolean call(E e) {
                        return startEvent.equals(e);
                    }
                });
            }

            @Override
            public <T> Observable.Transformer<T, T> bindToLifecycle() {
                Preconditions.checkNotNull(lifecycle, "lifecycle");
                Preconditions.checkNotNull(stopEvent, "stopEvent");
                return new Observable.Transformer<T, T>(){

                    public Observable<T> call(Observable<T> source) {
                        return source.takeUntil(lifecycle.takeFirst(new Func1<E, Boolean>(){

                            public Boolean call(E event) {
                                return event.equals(stopEvent);
                            }
                        }));
                    }
                };
            }
        };
    }
}

