/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.views;

import io.reactivesprint.Preconditions;
import io.reactivesprint.viewmodels.IViewModel;
import io.reactivesprint.views.ILifecycleProvider;
import io.reactivesprint.views.IView;
import io.reactivesprint.views.IViewBinder;
import io.reactivesprint.views.Views;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.internal.util.SubscriptionList;

public class ViewBinder<VM extends IViewModel>
implements IViewBinder<VM> {
    private final Object lock = new Object();
    private final IView<VM> view;
    private final ILifecycleProvider<?> lifecycleProvider;
    private SubscriptionList subscriptionList;

    public ViewBinder(IView<VM> view, ILifecycleProvider<?> lifecycleProvider) {
        Preconditions.checkNotNull(view, "view");
        Preconditions.checkNotNull(lifecycleProvider, "lifecycleProvider");
        this.view = view;
        this.lifecycleProvider = lifecycleProvider;
        lifecycleProvider.onStartBinding().doAfterTerminate(new Action0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                Object object = ViewBinder.this.lock;
                synchronized (object) {
                    if (ViewBinder.this.subscriptionList != null) {
                        ViewBinder.this.subscriptionList.unsubscribe();
                    }
                }
            }
        }).subscribe((Action1)new Action1<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Object event) {
                Object object = ViewBinder.this.lock;
                synchronized (object) {
                    if (ViewBinder.this.subscriptionList != null) {
                        ViewBinder.this.subscriptionList.unsubscribe();
                    }
                    ViewBinder.this.subscriptionList = new SubscriptionList();
                }
                SubscriptionList subscription = ViewBinder.this.bindViewModel();
                if (subscription != null) {
                    Object object2 = ViewBinder.this.lock;
                    synchronized (object2) {
                        ViewBinder.this.subscriptionList.add((Subscription)subscription);
                    }
                }
            }
        });
    }

    protected SubscriptionList bindViewModel() {
        VM viewModel = this.view.getViewModel();
        if (viewModel == null) {
            return null;
        }
        SubscriptionList subscription = new SubscriptionList();
        subscription.add(this.bindTitle(viewModel));
        subscription.add(this.bindLoading(viewModel));
        subscription.add(this.bindErrors(viewModel));
        return subscription;
    }

    public <T> Observable.Transformer<T, T> bindToLifecycle() {
        return this.lifecycleProvider.bindToLifecycle();
    }

    @Override
    public IView<VM> getView() {
        return this.view;
    }

    public ILifecycleProvider<?> getLifecycleProvider() {
        return this.lifecycleProvider;
    }

    @Override
    public Subscription bindActive(VM viewModel) {
        return null;
    }

    @Override
    public Subscription bindTitle(VM viewModel) {
        return viewModel.title().getObservable().compose(this.bindToLifecycle()).subscribe(Views.setTitle(this.view));
    }

    @Override
    public Subscription bindLoading(VM viewModel) {
        return viewModel.loading().getObservable().compose(this.bindToLifecycle()).subscribe(Views.presentLoading(this.view));
    }

    @Override
    public Subscription bindErrors(VM viewModel) {
        return viewModel.errors().compose(this.bindToLifecycle()).subscribe(Views.presentError(this.view));
    }
}

