/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.http;

import com.rodbate.httpserver.common.StringUtil;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;

public class RBHttpResponse
extends DefaultHttpResponse {
    public RBHttpResponse(HttpVersion version, HttpResponseStatus status) {
        super(version, status);
    }

    public RBHttpResponse(HttpVersion version, HttpResponseStatus status, boolean validateHeaders) {
        super(version, status, validateHeaders);
    }

    public RBHttpResponse(HttpVersion version, HttpResponseStatus status, boolean validateHeaders, boolean singleFieldHeaders) {
        super(version, status, validateHeaders, singleFieldHeaders);
    }

    public void setHeader(String name, Object value) {
        this.headers().set(name, value);
    }

    public void setContentTypeIfAbsent() {
        if (this.headers().get("Content-Type") == null) {
            this.headers().set("Content-Type", (Object)"application/json; charset=UTF-8");
        }
    }

    public void setHeaderIfAbsent(String name, Object value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        if (this.headers().get(name) == null) {
            this.headers().set(name, value);
        }
    }

    public void addCookie(Cookie cookie) {
        this.headers().add("Set-Cookie", (Object)ServerCookieEncoder.STRICT.encode(cookie));
    }

    public void setFileName(String fileName) {
        if (StringUtil.isNull(fileName)) {
            throw new RuntimeException("filename must not be null");
        }
        try {
            this.headers().set("Content-Disposition", (Object)("attachment; filename=" + URLEncoder.encode(fileName.trim(), "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void sendRedirect(String url) {
        if (StringUtil.isNull(url)) {
            throw new RuntimeException("url must not be null");
        }
        this.setStatus(HttpResponseStatus.SEE_OTHER);
        this.headers().set("Location", (Object)url);
    }
}

