/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.upload;

import com.rodbate.httpserver.common.ServerConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDeleteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDeleteListener.class);
    private static final long DEFAULT_DURATION = 1800L;
    private static final File DELETE_ON_START = new File(ServerConstants.JAVA_IO_TMPDIR, "httpserver_tmp_delete");
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final CopyOnWriteArraySet<Strategy> TODO_SET = new CopyOnWriteArraySet();
    private static final CopyOnWriteArraySet<Strategy> FAILURE_SET = new CopyOnWriteArraySet();
    private static final Runnable DELETE_TASK = FileDeleteListener::lambda$static$0;
    private static final Runnable INIT_DELETE = () -> {
        try {
            if (DELETE_ON_START.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(DELETE_ON_START)));
                while ((line = reader.readLine()) != null) {
                    if (!new File(line).delete()) continue;
                    LOGGER.info("=============  delete file {} successfully", (Object)line);
                }
                reader.close();
                if (DELETE_ON_START.delete()) {
                    LOGGER.info("=============  delete file {} successfully", (Object)DELETE_ON_START.getPath());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };

    public static void init() {
        Thread task = new Thread(INIT_DELETE);
        task.setName("Daemon Thread-1 Delete File");
        task.setDaemon(true);
        task.setPriority(5);
        task.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFilePath(String filePath) {
        ReentrantLock lock = LOCK;
        try {
            lock.lock();
            if (DELETE_ON_START.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(DELETE_ON_START)));
                ArrayList<String> paths = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    if (filePath.equals(line)) continue;
                    paths.add(line);
                }
                reader.close();
                FileOutputStream fos = new FileOutputStream(DELETE_ON_START);
                for (String s : paths) {
                    fos.write((s + ServerConstants.LINE_SEPARATOR).getBytes());
                }
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(File file, long duration) throws IOException {
        ReentrantLock lock = LOCK;
        try {
            lock.lock();
            if (duration < 0L) {
                throw new IllegalArgumentException("Duration not negative");
            }
            if (duration == 0L) {
                duration = 1800L;
            }
            Strategy strategy = new Strategy(file, System.currentTimeMillis() / 1000L, duration);
            TODO_SET.add(strategy);
            if (!DELETE_ON_START.exists()) {
                DELETE_ON_START.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(DELETE_ON_START, true);
            fos.write((file.getPath() + ServerConstants.LINE_SEPARATOR).getBytes());
            fos.close();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$static$0() {
        while (true) lbl-1000:
        // 6 sources

        {
            for (Strategy s : FileDeleteListener.TODO_SET) {
                current = System.currentTimeMillis() / 1000L;
                if (s.startTime + s.duration > current) continue;
                if (!s.file.exists()) {
                    FileDeleteListener.TODO_SET.remove(s);
                    throw new RuntimeException("File not exists");
                }
                if (!s.file.delete()) {
                    FileDeleteListener.TODO_SET.remove(s);
                    FileDeleteListener.FAILURE_SET.add(s);
                    FileDeleteListener.LOGGER.info("=============  fail to delete file {} ", (Object)s.file.getPath());
                    continue;
                }
                FileDeleteListener.TODO_SET.remove(s);
                FileDeleteListener.LOGGER.info("=============  delete file {} successfully", (Object)s.file.getPath());
                FileDeleteListener.removeFilePath(s.file.getPath());
            }
            try {
                Thread.sleep(1000L);
                ** continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    static {
        Thread task = new Thread(DELETE_TASK);
        task.setName("Daemon Thread-2 Delete File");
        task.setDaemon(true);
        task.setPriority(5);
        task.start();
    }

    static class Strategy {
        File file;
        long startTime;
        long duration;

        public Strategy(File file, long startTime, long duration) {
            this.file = file;
            this.startTime = startTime;
            this.duration = duration;
        }
    }
}

