/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.upload;

import com.rodbate.httpserver.common.StringUtil;
import com.rodbate.httpserver.http.RBHttpRequest;
import com.rodbate.httpserver.upload.FileItem;
import com.rodbate.httpserver.upload.FileItemFactory;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class MultipartFileParser {
    private final FileItemFactory factory;

    public MultipartFileParser(FileItemFactory factory) {
        this.factory = factory;
    }

    public List<FileItem> parse(RBHttpRequest request) {
        ArrayList<FileItem> fileItems;
        block18: {
            String boundaryKv;
            fileItems = new ArrayList<FileItem>();
            String requestContentType = request.getHeaderByName("Content-Type");
            if ((requestContentType = StringUtil.removeBlankSpace(requestContentType)).contains(";") && (boundaryKv = requestContentType.split(";")[1]).contains("boundary")) {
                String boundary = boundaryKv.split("=")[1];
                String startBoundary = "--" + boundary;
                String endBoundary = "--" + boundary + "--";
                try {
                    FileItem multipartFile = request.getFileItem();
                    if (multipartFile == null) break block18;
                    InputStream inputStream = multipartFile.getInputStream();
                    if (inputStream instanceof ByteArrayInputStream) {
                        ByteArrayInputStream bais = (ByteArrayInputStream)inputStream;
                        byte[] b = new byte[bais.available()];
                        bais.read(b);
                        bais.close();
                        String content = new String(b);
                        boolean flag = false;
                        int i = 0;
                        block2: while (i < content.length() && !flag) {
                            OutputStream out;
                            FileItem item;
                            String v;
                            i += startBoundary.length() + 2;
                            StringBuilder disposition = new StringBuilder();
                            do {
                                disposition.append(content.charAt(i++));
                            } while (content.charAt(i) != '\r' || content.charAt(i + 1) != '\n');
                            i += 2;
                            String dis = disposition.toString();
                            if (dis.contains("file")) {
                                OutputStream out2;
                                FileItem item2;
                                String v2;
                                String filename = dis.split(";")[2].split("=")[1].replace("\"", "");
                                filename = URLDecoder.decode(filename, "utf-8");
                                StringBuilder contentTypeSb = new StringBuilder();
                                do {
                                    contentTypeSb.append(content.charAt(i++));
                                } while (content.charAt(i) != '\r' || content.charAt(i + 1) != '\n');
                                i += 2;
                                String contentType = contentTypeSb.toString().split(":")[1].trim();
                                i += 2;
                                StringBuilder value = new StringBuilder();
                                do {
                                    value.append(content.charAt(i++));
                                    if (content.charAt(i) != '-' || content.charAt(i + 1) != '-' || !content.substring(i, startBoundary.length() + 1).equals(startBoundary)) continue;
                                    v2 = value.substring(0, value.length() - 1);
                                    item2 = this.factory.createItem("file", contentType, filename, false);
                                    out2 = item2.getOutputStream();
                                    out2.write(v2.getBytes());
                                    out2.close();
                                    fileItems.add(item2);
                                    continue block2;
                                } while (content.charAt(i) != '-' || content.charAt(i + 1) != '-' || !content.substring(i, endBoundary.length() + 1).equals(endBoundary));
                                v2 = value.substring(0, value.length() - 1);
                                item2 = this.factory.createItem("file", contentType, filename, false);
                                out2 = item2.getOutputStream();
                                out2.write(v2.getBytes());
                                out2.close();
                                fileItems.add(item2);
                                flag = true;
                                continue;
                            }
                            String name = dis.split(";")[1].split("=")[1].replace("\"", "");
                            i += 2;
                            StringBuilder value = new StringBuilder();
                            do {
                                value.append(content.charAt(i++));
                                if (content.charAt(i) != '-' || content.charAt(i + 1) != '-' || !content.substring(i, startBoundary.length() + 1).equals(startBoundary)) continue;
                                v = value.substring(0, value.length() - 1);
                                item = this.factory.createItem(name, null, null, true);
                                out = item.getOutputStream();
                                out.write(v.getBytes());
                                out.close();
                                fileItems.add(item);
                                continue block2;
                            } while (content.charAt(i) != '-' || content.charAt(i + 1) != '-' || !content.substring(i, endBoundary.length() + 1).equals(endBoundary));
                            v = value.substring(0, value.length() - 1);
                            item = this.factory.createItem(name, null, null, true);
                            out = item.getOutputStream();
                            out.write(v.getBytes());
                            out.close();
                            fileItems.add(item);
                            flag = true;
                        }
                    }
                    if (!(inputStream instanceof FileInputStream)) break block18;
                    FileInputStream fis = (FileInputStream)inputStream;
                    int length = fis.available();
                    FileChannel channel = fis.getChannel();
                    ByteBuffer buffer = ByteBuffer.allocate(1024);
                    ByteBuffer startBoundaryBuffer = ByteBuffer.allocate(startBoundary.length());
                    ByteBuffer endBoundaryBuffer = ByteBuffer.allocate(endBoundary.length());
                    ByteBuffer one = ByteBuffer.allocate(1);
                    long currentPosition = 0L;
                    while (true) {
                        channel.position(currentPosition += (long)(startBoundary.length() + 2));
                        channel.read(buffer);
                        buffer.flip();
                        currentPosition = channel.position();
                        currentPosition -= 1024L;
                        StringBuilder dispositionSb = new StringBuilder();
                        while (true) {
                            byte b1 = buffer.get();
                            ++currentPosition;
                            if (b1 == 13 && buffer.get() == 10) {
                                ++currentPosition;
                                break;
                            }
                            dispositionSb.append((char)b1);
                        }
                        String disposition = dispositionSb.toString();
                        if (disposition.contains("file")) {
                            String filename = disposition.split(";")[2].split("=")[1].replace("\"", "");
                            filename = URLDecoder.decode(filename, "utf-8");
                            StringBuilder contentTypeSb = new StringBuilder();
                            while (true) {
                                byte b1 = buffer.get();
                                ++currentPosition;
                                if (b1 == 13 && buffer.get() == 10) {
                                    ++currentPosition;
                                    break;
                                }
                                contentTypeSb.append((char)b1);
                            }
                            String contentTypeStr = contentTypeSb.toString();
                            String contentType = contentTypeStr.split(":")[1].trim();
                            FileItem item = this.factory.createItem("file", contentType, filename, false);
                            OutputStream outputStream = item.getOutputStream();
                            channel.position(currentPosition += 2L);
                            fileItems.add(item);
                            while (true) {
                                channel.read(one);
                                channel.read(endBoundaryBuffer);
                                currentPosition = channel.position();
                                channel.position(currentPosition -= (long)endBoundary.length());
                                if (new String(endBoundaryBuffer.array()).equals(endBoundary)) {
                                    endBoundaryBuffer.clear();
                                    break block18;
                                }
                                endBoundaryBuffer.clear();
                                channel.read(startBoundaryBuffer);
                                currentPosition = channel.position();
                                channel.position(currentPosition -= (long)startBoundary.length());
                                if (new String(startBoundaryBuffer.array()).equals(startBoundary)) break;
                                startBoundaryBuffer.clear();
                                outputStream.write(one.array());
                                one.clear();
                            }
                            startBoundaryBuffer.clear();
                            buffer.clear();
                            System.out.println();
                            continue;
                        }
                        String string = disposition.split(";")[1].split("=")[1].replace("\"", "");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fileItems;
    }
}

