/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.upload;

import com.rodbate.httpserver.common.IOUtils;
import com.rodbate.httpserver.upload.DiskThresholdOutputStream;
import com.rodbate.httpserver.upload.FileItem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class DiskFileItem
implements FileItem {
    private static final AtomicInteger COUNT = new AtomicInteger(0);
    private final String contentType;
    private final String fieldName;
    private final String filename;
    private final boolean isFormField;
    private final int sizeThreshold;
    private File repository;
    private byte[] cachedContent;
    private long size = -1L;
    private DiskThresholdOutputStream outputStream;
    private File tempFile;

    public DiskFileItem(String contentType, String fieldName, String filename, boolean isFormField, int sizeThreshold, File repository) {
        this.contentType = contentType;
        this.fieldName = fieldName;
        this.filename = filename;
        this.isFormField = isFormField;
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            this.outputStream.close();
            return new FileInputStream(this.outputStream.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.outputStream.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public boolean isFormField() {
        return this.isFormField;
    }

    @Override
    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.outputStream.isInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null) {
                this.cachedContent = this.outputStream.getData();
            }
            return this.cachedContent;
        }
        byte[] array = new byte[(int)this.getSize()];
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(this.outputStream.getFile()));
            is.read(array);
        }
        catch (IOException e) {
            array = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return array;
    }

    @Override
    public String getString() {
        return new String(this.get());
    }

    @Override
    public long getSize() {
        if (this.size > 0L) {
            return this.size;
        }
        if (this.isInMemory()) {
            if (this.cachedContent != null) {
                return this.cachedContent.length;
            }
            if (this.outputStream != null) {
                this.cachedContent = this.outputStream.getData();
                return this.cachedContent.length;
            }
        } else if (this.outputStream != null) {
            return this.outputStream.getFile().length();
        }
        return 0L;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            File tempFile = this.getTempFile();
            this.outputStream = new DiskThresholdOutputStream(this.sizeThreshold, tempFile);
        }
        return this.outputStream;
    }

    public File getTempFile() {
        if (this.tempFile == null) {
            File tmpDir = this.repository;
            if (this.repository == null) {
                tmpDir = new File(System.getProperty("java.io.tmpdir"));
            }
            String tmpFilename = String.format("tmp_%s_%s", UUID.randomUUID().toString().replace("-", "_"), this.getUniqueId());
            this.tempFile = new File(tmpDir, tmpFilename);
            this.tempFile.deleteOnExit();
        }
        return this.tempFile;
    }

    private String getUniqueId() {
        int limit = 10000;
        int id = COUNT.getAndIncrement();
        if (id >= limit) {
            COUNT.compareAndSet(id + 1, 0);
            id = COUNT.getAndIncrement();
        }
        String idStr = String.valueOf(id);
        return ("0000" + idStr).substring(idStr.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File not exists");
        }
        if (this.isInMemory()) {
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(file);
                fos.write(this.get());
            }
        }
        File storeFile = this.getStoreLocation();
        if (storeFile != null) {
            this.size = storeFile.length();
            if (!storeFile.renameTo(file)) {
                BufferedInputStream bis = null;
                FilterOutputStream bos = null;
                try {
                    bis = new BufferedInputStream(new FileInputStream(storeFile));
                    bos = new BufferedOutputStream(new FileOutputStream(file));
                    IOUtils.copy(bis, bos);
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
            }
        }
    }

    public File getStoreLocation() {
        if (this.outputStream == null) {
            return null;
        }
        return this.outputStream.getFile();
    }
}

