/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.upload;

import com.rodbate.httpserver.common.IOUtils;
import com.rodbate.httpserver.upload.ThresholdOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DiskThresholdOutputStream
extends ThresholdOutputStream {
    private OutputStream currentOutputStream;
    private ByteArrayOutputStream memoryOutputStream;
    private File outputFile;
    private final String prefix;
    private final String suffix;
    private final File directory;
    private boolean closed;

    public DiskThresholdOutputStream(int sizeThreshold, File outputFile, String prefix, String suffix, File directory) {
        super(sizeThreshold);
        this.outputFile = outputFile;
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
        this.memoryOutputStream = new ByteArrayOutputStream();
        this.currentOutputStream = this.memoryOutputStream;
    }

    public DiskThresholdOutputStream(int sizeThreshold, File outputFile) {
        this(sizeThreshold, outputFile, null, null, null);
    }

    public DiskThresholdOutputStream(int sizeThreshold, String prefix, String suffix, File directory) {
        this(sizeThreshold, null, prefix, suffix, directory);
        if (prefix == null) {
            throw new RuntimeException("Temporary File Prefix is Missing");
        }
    }

    @Override
    protected OutputStream getStream() {
        return this.currentOutputStream;
    }

    @Override
    protected void reachThreshold() throws IOException {
        if (this.prefix != null) {
            this.outputFile = File.createTempFile(this.prefix, this.suffix, this.directory);
        }
        FileOutputStream fos = new FileOutputStream(this.outputFile);
        this.memoryOutputStream.writeTo(fos);
        this.currentOutputStream = fos;
        this.memoryOutputStream = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        if (!this.closed) {
            throw new IOException("Stream not close");
        }
        if (this.isInMemory()) {
            this.memoryOutputStream.writeTo(outputStream);
        } else {
            try (FileInputStream fis = null;){
                fis = new FileInputStream(this.outputFile);
                IOUtils.copy(fis, outputStream);
            }
        }
    }
}

