/*
 * Decompiled with CFR 0.152.
 */
package com.github.samyuan1990.FabricJavaPool;

import com.github.samyuan1990.FabricJavaPool.FabricConnection;
import com.github.samyuan1990.FabricJavaPool.FabricJavaPoolConfig;
import java.io.File;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.NetworkConfig;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.security.CryptoSuite;

public class FabricJavaPool
extends GenericObjectPool<FabricConnection> {
    public FabricJavaPool(User appUser, String channel) {
        super((PooledObjectFactory)new ChannelPoolFactory(new FabricJavaPoolConfig().getConfigNetworkPath(), appUser, channel), (GenericObjectPoolConfig)new FabricJavaPoolConfig());
    }

    public FabricJavaPool(User appUser, String channel, FabricJavaPoolConfig config) {
        super((PooledObjectFactory)new ChannelPoolFactory(config.getConfigNetworkPath(), appUser, channel), (GenericObjectPoolConfig)config);
    }

    private static class ChannelPoolFactory
    extends BasePooledObjectFactory<FabricConnection> {
        private String config_network_path = "";
        private User appUser;
        private String channel = "";

        ChannelPoolFactory(String configNetworkPath, User appUser, String channel) {
            this.config_network_path = configNetworkPath;
            this.appUser = appUser;
            this.channel = channel;
        }

        public FabricConnection create() throws Exception {
            CryptoSuite cryptoSuite = CryptoSuite.Factory.getCryptoSuite();
            HFClient hfclient = HFClient.createNewInstance();
            hfclient.setCryptoSuite(cryptoSuite);
            NetworkConfig networkConfig = NetworkConfig.fromJsonFile((File)new File(this.config_network_path));
            hfclient.setUserContext(this.appUser);
            hfclient.loadChannelFromConfig(this.channel, networkConfig);
            Channel myChannel = hfclient.getChannel(this.channel);
            myChannel.initialize();
            FabricConnection myConnection = new FabricConnection(hfclient, myChannel, this.appUser);
            return myConnection;
        }

        public PooledObject<FabricConnection> wrap(FabricConnection obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }
}

