/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package com.github.samyuan1990.FabricJavaPool.Pool;

import java.io.File;
import java.lang.reflect.Proxy;

import com.github.samyuan1990.FabricJavaPool.FabricJavaPoolConfig;
import com.github.samyuan1990.FabricJavaPool.api.FabricConnection;
import com.github.samyuan1990.FabricJavaPool.cache.FabricConnectionImplCacheProxy;
import com.github.samyuan1990.FabricJavaPool.cache.FabricContractConnectImplCacheProxy;
import com.github.samyuan1990.FabricJavaPool.impl.FabricConnectionImpl;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.NetworkConfig;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.security.CryptoSuite;

public class FabricJavaPool extends GenericObjectPool<FabricConnection> {

    public FabricJavaPool(User appUser, String channel) {
        super(new ConnectionPoolFactory(appUser, channel));
    }

    public FabricJavaPool(User appUser, String channel, FabricJavaPoolConfig config) {
        super(new ConnectionPoolFactory(appUser, channel, config));
    }

    private static class ConnectionPoolFactory extends BasePooledObjectFactory<FabricConnection> {

        private FabricJavaPoolConfig config =  new FabricJavaPoolConfig();
        private String config_network_path = "";
        private User appUser;
        private String channel = "";

        ConnectionPoolFactory(User appUser, String channel) {
            this.config_network_path = config.getConfigNetworkPath();
            this.appUser = appUser;
            this.channel = channel;
        }

        ConnectionPoolFactory(User appUser, String channel, FabricJavaPoolConfig config) {
            this.config = config;
            this.config_network_path = config.getConfigNetworkPath();
            this.appUser = appUser;
            this.channel = channel;
        }

        @Override
        public FabricConnection create() throws Exception {
            FabricConnectionImpl myConnection;
            CryptoSuite cryptoSuite = CryptoSuite.Factory.getCryptoSuite();
            HFClient hfclient = HFClient.createNewInstance();
            hfclient.setCryptoSuite(cryptoSuite);
            NetworkConfig networkConfig = NetworkConfig.fromJsonFile(new File(config_network_path));
            hfclient.setUserContext(appUser);
            hfclient.loadChannelFromConfig(channel, networkConfig);
            Channel myChannel = hfclient.getChannel(channel);
            myChannel.initialize();
            myConnection = new FabricConnectionImpl(hfclient, myChannel, appUser);
            if (config.isUseCache()) {
                FabricConnectionImplCacheProxy proxy = new FabricConnectionImplCacheProxy(myConnection, config.getCacheURL(), appUser.getName(), channel, config.getCacheTimeout());
                return (FabricConnection) Proxy.newProxyInstance(FabricConnectionImpl.class.getClassLoader(), new Class[]{FabricConnection.class}, proxy);
            } else {
                return myConnection;
            }

        }

        @Override
        public PooledObject<FabricConnection> wrap(FabricConnection obj) {
            return new DefaultPooledObject<>(obj);
        }

    }
}
