/*
 * Decompiled with CFR 0.152.
 */
package com.github.samyuan1990.FabricJavaPool;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class FabricJavaPoolConfig
extends GenericObjectPoolConfig {
    private boolean useCache;
    private String cacheURL;
    private int cacheTimeout;
    private static String configFile = "/FabricJavaPool.properties";
    private String configNetworkPath;
    private Properties properties;
    private String walletPath;

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public String getCacheURL() {
        return this.cacheURL;
    }

    public void setCacheURL(String cacheURL) {
        this.cacheURL = cacheURL;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(int cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public void setConfigNetworkPath(String configNetworkPath) {
        this.configNetworkPath = configNetworkPath;
    }

    public String getConfigNetworkPath() {
        return this.configNetworkPath;
    }

    public void setWalletPath(String walletPath) {
        this.walletPath = walletPath;
    }

    public String getWalletPath() {
        return this.walletPath;
    }

    public FabricJavaPoolConfig(String configNetworkPath) {
        this.setConfigNetworkPath(configNetworkPath);
    }

    public FabricJavaPoolConfig() {
        this.loadConfig(configFile);
    }

    public void loadConfig(String file) {
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(file);
            Properties properties = new Properties();
            properties.load(in);
            this.setConfigNetworkPath(properties.getProperty("configNetworkPath"));
            this.setWalletPath(properties.getProperty("walletPath"));
            this.setMaxTotal(Integer.valueOf(properties.getProperty("maxTotal")));
            this.setMaxIdle(Integer.valueOf(properties.getProperty("maxIdle")));
            this.setMinIdle(Integer.valueOf(properties.getProperty("minIdle")));
            this.setMaxWaitMillis(Integer.valueOf(properties.getProperty("maxWaitMillis")).intValue());
            this.setUseCache(Boolean.valueOf(properties.getProperty("UseCache")));
            if (this.isUseCache()) {
                this.setCacheURL(properties.getProperty("cacheURL"));
                this.setCacheTimeout(Integer.valueOf(properties.getProperty("cacheTimeout")));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

