/*
 * Decompiled with CFR 0.152.
 */
package com.github.samyuan1990.FabricJavaPool.Pool;

import com.github.samyuan1990.FabricJavaPool.FabricJavaPoolConfig;
import com.github.samyuan1990.FabricJavaPool.api.FabricConnection;
import com.github.samyuan1990.FabricJavaPool.cache.FabricContractConnectImplCacheProxy;
import com.github.samyuan1990.FabricJavaPool.impl.FabricContractConnectImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.hyperledger.fabric.gateway.Gateway;
import org.hyperledger.fabric.gateway.Wallet;

public class FabricGatewayPool
extends GenericObjectPool<FabricConnection> {
    public FabricGatewayPool(String userName, String channel) {
        super((PooledObjectFactory)new ContractPoolFactory(userName, channel), (GenericObjectPoolConfig)new FabricJavaPoolConfig());
    }

    public FabricGatewayPool(String userName, String channel, FabricJavaPoolConfig config) {
        super((PooledObjectFactory)new ContractPoolFactory(config, userName, channel), (GenericObjectPoolConfig)config);
    }

    private static class ContractPoolFactory
    extends BasePooledObjectFactory<FabricConnection> {
        private FabricJavaPoolConfig config = new FabricJavaPoolConfig();
        private String userName;
        private String channel;

        ContractPoolFactory(String userName, String channel) {
            this.userName = userName;
            this.channel = channel;
        }

        ContractPoolFactory(FabricJavaPoolConfig config, String userName, String channel) {
            this.config = config;
            this.userName = userName;
            this.channel = channel;
        }

        public FabricConnection create() throws Exception {
            Path walletDirectory = Paths.get(this.config.getWalletPath(), new String[0]);
            Wallet wallet = Wallet.createFileSystemWallet((Path)walletDirectory);
            Path networkConfigFile = Paths.get(this.config.getConfigNetworkPath(), new String[0]);
            Gateway.Builder builder = Gateway.createBuilder().identity(wallet, this.userName).networkConfig(networkConfigFile);
            Gateway gateway = builder.connect();
            FabricContractConnectImpl fCCI = new FabricContractConnectImpl(gateway.getNetwork(this.channel));
            if (this.config.isUseCache()) {
                FabricContractConnectImplCacheProxy proxy = new FabricContractConnectImplCacheProxy(fCCI, this.config.getCacheURL(), this.userName, this.channel, this.config.getCacheTimeout());
                return (FabricConnection)Proxy.newProxyInstance(FabricContractConnectImpl.class.getClassLoader(), new Class[]{FabricConnection.class}, (InvocationHandler)proxy);
            }
            return fCCI;
        }

        public PooledObject<FabricConnection> wrap(FabricConnection obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }
}

