/*
 * Decompiled with CFR 0.152.
 */
package com.github.samyuan1990.FabricJavaPool.Pool;

import com.github.samyuan1990.FabricJavaPool.FabricJavaPoolConfig;
import com.github.samyuan1990.FabricJavaPool.api.FabricConnection;
import com.github.samyuan1990.FabricJavaPool.cache.FabricConnectionImplCacheProxy;
import com.github.samyuan1990.FabricJavaPool.impl.FabricConnectionImpl;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.NetworkConfig;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.security.CryptoSuite;

public class FabricJavaPool
extends GenericObjectPool<FabricConnection> {
    public FabricJavaPool(User appUser, String channel) {
        super((PooledObjectFactory)new ConnectionPoolFactory(appUser, channel));
    }

    public FabricJavaPool(User appUser, String channel, FabricJavaPoolConfig config) {
        super((PooledObjectFactory)new ConnectionPoolFactory(appUser, channel, config));
    }

    private static class ConnectionPoolFactory
    extends BasePooledObjectFactory<FabricConnection> {
        private FabricJavaPoolConfig config = new FabricJavaPoolConfig();
        private String config_network_path = "";
        private User appUser;
        private String channel = "";

        ConnectionPoolFactory(User appUser, String channel) {
            this.config_network_path = this.config.getConfigNetworkPath();
            this.appUser = appUser;
            this.channel = channel;
        }

        ConnectionPoolFactory(User appUser, String channel, FabricJavaPoolConfig config) {
            this.config = config;
            this.config_network_path = config.getConfigNetworkPath();
            this.appUser = appUser;
            this.channel = channel;
        }

        public FabricConnection create() throws Exception {
            CryptoSuite cryptoSuite = CryptoSuite.Factory.getCryptoSuite();
            HFClient hfclient = HFClient.createNewInstance();
            hfclient.setCryptoSuite(cryptoSuite);
            NetworkConfig networkConfig = NetworkConfig.fromJsonFile((File)new File(this.config_network_path));
            hfclient.setUserContext(this.appUser);
            hfclient.loadChannelFromConfig(this.channel, networkConfig);
            Channel myChannel = hfclient.getChannel(this.channel);
            myChannel.initialize();
            FabricConnectionImpl myConnection = new FabricConnectionImpl(hfclient, myChannel, this.appUser);
            if (this.config.isUseCache()) {
                FabricConnectionImplCacheProxy proxy = new FabricConnectionImplCacheProxy(myConnection, this.config.getCacheURL(), this.appUser.getName(), this.channel, this.config.getCacheTimeout());
                return (FabricConnection)Proxy.newProxyInstance(FabricConnectionImpl.class.getClassLoader(), new Class[]{FabricConnection.class}, (InvocationHandler)proxy);
            }
            return myConnection;
        }

        public PooledObject<FabricConnection> wrap(FabricConnection obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }
}

