/*
 * Decompiled with CFR 0.152.
 */
package com.github.samyuan1990.FabricJavaPool.cache;

import com.github.samyuan1990.FabricJavaPool.ExecuteResult;
import com.github.samyuan1990.FabricJavaPool.cache.FabricContractConnectImplCacheProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.hyperledger.fabric.protos.ledger.rwset.kvrwset.KvRwset;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.TxReadWriteSetInfo;

public class FabricConnectionImplCacheProxy
extends FabricContractConnectImplCacheProxy
implements InvocationHandler {
    public FabricConnectionImplCacheProxy(Object obj, String cacheURL, String userName, String channelName, int timeout) {
        super(obj, cacheURL, userName, channelName, timeout);
    }

    public FabricConnectionImplCacheProxy(String cacheURL, String user, String mychannel, int timeout) {
        super(cacheURL, user, mychannel, timeout);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (method.getName().equals("query")) {
            String key = this.genericKey(this.userName, this.channelName, args);
            result = this.memcachedClient.get(key);
            if (result != null) {
                return result;
            }
            result = method.invoke(this.obj, args);
            ExecuteResult executeResult = (ExecuteResult)result;
            if (executeResult.getPropResp() == null) {
                return result;
            }
            for (ProposalResponse p : executeResult.getPropResp()) {
                TxReadWriteSetInfo txReadWriteSetInfo = p.getChaincodeActionResponseReadWriteSetInfo();
                for (TxReadWriteSetInfo.NsRwsetInfo nsRwsetInfo : txReadWriteSetInfo.getNsRwsetInfos()) {
                    KvRwset.KVRWSet rws = nsRwsetInfo.getRwset();
                    for (KvRwset.KVRead readList : rws.getReadsList()) {
                        String blockKey = readList.getKey();
                        this.memcachedClient.set(blockKey, this.timeout, (Object)key);
                    }
                }
            }
            this.memcachedClient.set(key, this.timeout, result);
            return result;
        }
        if (method.getName().equals("invoke")) {
            result = method.invoke(this.obj, args);
            ExecuteResult executeResult = (ExecuteResult)result;
            if (executeResult.getPropResp() == null) {
                return result;
            }
            for (ProposalResponse p : executeResult.getPropResp()) {
                TxReadWriteSetInfo txReadWriteSetInfo = p.getChaincodeActionResponseReadWriteSetInfo();
                for (TxReadWriteSetInfo.NsRwsetInfo nsRwsetInfo : txReadWriteSetInfo.getNsRwsetInfos()) {
                    KvRwset.KVRWSet rws = nsRwsetInfo.getRwset();
                    for (KvRwset.KVRead readList : rws.getReadsList()) {
                        String blockKey = readList.getKey();
                        String blockCache = (String)this.memcachedClient.get(blockKey);
                        if (blockCache.equals(null)) continue;
                        this.memcachedClient.delete(blockCache);
                        this.memcachedClient.delete(blockKey);
                    }
                }
            }
            return result;
        }
        result = method.invoke(this.obj, args);
        return result;
    }
}

