/*
 * Decompiled with CFR 0.152.
 */
package com.github.samyuan1990.FabricJavaPool.impl;

import com.github.samyuan1990.FabricJavaPool.ExecuteResult;
import com.github.samyuan1990.FabricJavaPool.RunTimeException;
import com.github.samyuan1990.FabricJavaPool.Util;
import com.github.samyuan1990.FabricJavaPool.api.FabricConnection;
import java.util.Collection;
import org.hyperledger.fabric.sdk.ChaincodeID;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.QueryByChaincodeRequest;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.User;

public class FabricConnectionImpl
implements FabricConnection {
    private HFClient hfclient;
    private Channel mychannel;
    private User user;

    public FabricConnectionImpl() {
        this.hfclient = HFClient.createNewInstance();
    }

    public FabricConnectionImpl(HFClient hfclient, Channel mychannel, User user) {
        this.hfclient = hfclient;
        this.mychannel = mychannel;
        this.user = user;
    }

    public Channel getMychannel() {
        return this.mychannel;
    }

    public void setMychannel(Channel mychannel) {
        this.mychannel = mychannel;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public ExecuteResult query(String chainCode, String fcn, String ... arguments) throws Exception {
        ChaincodeID cci = ChaincodeID.newBuilder().setName(chainCode).build();
        return this.query(cci, fcn, arguments);
    }

    public ExecuteResult query(ChaincodeID chaincodeID, String fcn, String ... arguments) throws Exception {
        QueryByChaincodeRequest transactionProposalRequest = this.hfclient.newQueryProposalRequest();
        transactionProposalRequest.setChaincodeID(chaincodeID);
        transactionProposalRequest.setFcn(fcn);
        transactionProposalRequest.setArgs(arguments);
        transactionProposalRequest.setUserContext(this.getUser());
        Collection queryPropResp = this.getMychannel().queryByChaincode(transactionProposalRequest);
        return this.processProposalResponses(queryPropResp);
    }

    public ExecuteResult invoke(ChaincodeID chaincodeID, String fcn, String ... arguments) throws Exception {
        TransactionProposalRequest transactionProposalRequest = this.hfclient.newTransactionProposalRequest();
        transactionProposalRequest.setChaincodeID(chaincodeID);
        transactionProposalRequest.setFcn(fcn);
        transactionProposalRequest.setArgs(arguments);
        transactionProposalRequest.setUserContext(this.getUser());
        Collection invokePropResp = this.getMychannel().sendTransactionProposal(transactionProposalRequest);
        ExecuteResult eR = this.processProposalResponses(invokePropResp);
        this.getMychannel().sendTransaction(invokePropResp);
        return eR;
    }

    @Override
    public ExecuteResult invoke(String chainCode, String fcn, String ... arguments) throws Exception {
        ChaincodeID cci = ChaincodeID.newBuilder().setName(chainCode).build();
        return this.invoke(cci, fcn, arguments);
    }

    private ExecuteResult processProposalResponses(Collection<ProposalResponse> propResp) throws RunTimeException {
        String payload = "";
        int i = 0;
        for (ProposalResponse response : propResp) {
            if (response.getStatus() == ChaincodeResponse.Status.SUCCESS) {
                if (i == 0) {
                    payload = response.getProposalResponse().getResponse().getPayload().toStringUtf8();
                }
                String currentPayload = response.getProposalResponse().getResponse().getPayload().toStringUtf8();
                if (null != payload && null != currentPayload && !payload.equals(currentPayload)) {
                    throw new RunTimeException(response.getStatus(), Util.resultOnPeersDiff);
                }
            } else {
                throw new RunTimeException(response.getStatus(), Util.errorHappenDuringQuery);
            }
            ++i;
        }
        return new ExecuteResult(payload, propResp);
    }
}

