/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.salesforce.SalesforceJsonTokenExtractor;
import com.github.scribejava.core.builder.api.ClientAuthenticationType;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Verb;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class SalesforceApi
extends DefaultApi20 {
    private static final String PRODUCTION_HOST = "login.salesforce.com";
    private static final String SANDBOX_HOST = "test.salesforce.com";
    private static final String PROTOCOL = "https://";
    private static final String ACCESS_PATH = "/services/oauth2/token";
    private static final String AUTHORIZE_PATH = "/services/oauth2/authorize";
    private final String accessTokenUrl;
    private final String authorizationBaseUrl;

    protected SalesforceApi(String hostName) {
        this.accessTokenUrl = PROTOCOL + hostName + ACCESS_PATH;
        this.authorizationBaseUrl = PROTOCOL + hostName + AUTHORIZE_PATH;
        try {
            SSLSocket socket = (SSLSocket)SSLContext.getDefault().getSocketFactory().createSocket();
            if (!SalesforceApi.isTLSv11orUpperEnabled(socket)) {
                throw new IllegalStateException("Salesforce API required to use TLSv1.1 or upper. Enabled it by invoking method initTLSv11orUpper or somehow else");
            }
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Salesforce API required to use TLSv1.1 or upper. Enabled it by invoking method initTLSv11orUpper or somehow else");
        }
    }

    public static SalesforceApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static SalesforceApi sandbox() {
        return new SalesforceApi(SANDBOX_HOST);
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public String getAccessTokenEndpoint() {
        return this.accessTokenUrl;
    }

    protected String getAuthorizationBaseUrl() {
        return this.authorizationBaseUrl;
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return SalesforceJsonTokenExtractor.instance();
    }

    private static boolean isTLSv11orUpperEnabled(SSLSocket socket) {
        for (String protocol : socket.getEnabledProtocols()) {
            if (!"TLSv1.2".equals(protocol) && !"TLSv1.1".equals(protocol)) continue;
            return true;
        }
        return false;
    }

    public static void initTLSv11orUpper() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        SSLContext context;
        SSLSocket socket = (SSLSocket)SSLContext.getDefault().getSocketFactory().createSocket();
        if (SalesforceApi.isTLSv11orUpperEnabled(socket)) {
            return;
        }
        boolean supportTLSv11 = false;
        boolean supportTLSv12 = false;
        for (String protocol : socket.getSupportedProtocols()) {
            if ("TLSv1.2".equals(protocol)) {
                supportTLSv12 = true;
                break;
            }
            if (!"TLSv1.1".equals(protocol)) continue;
            supportTLSv11 = true;
        }
        if (supportTLSv12) {
            context = SSLContext.getInstance("TLSv1.2");
        } else if (supportTLSv11) {
            context = SSLContext.getInstance("TLSv1.1");
        } else {
            throw new NoSuchAlgorithmException("for Salesforce API to work you need jvm with TLS 1.1 or 1.2 support");
        }
        context.init(null, null, null);
        SSLContext.setDefault(context);
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return ClientAuthenticationType.REQUEST_BODY;
    }

    private static class InstanceHolder {
        private static final SalesforceApi INSTANCE = new SalesforceApi("login.salesforce.com");

        private InstanceHolder() {
        }
    }
}

