/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.utils;

import java.util.Locale;
import java.util.regex.Pattern;

public abstract class Preconditions {
    private static final String DEFAULT_MESSAGE = "Received an invalid parameter";
    private static final String URL_REGEXP = "^[a-zA-Z][a-zA-Z0-9+.-]*://\\S+";

    public static void checkNotNull(Object object, String errorMsg) {
        Preconditions.check(object != null, errorMsg);
    }

    public static void checkEmptyString(String string, String errorMsg) {
        Preconditions.check(string != null && !string.trim().isEmpty(), errorMsg);
    }

    public static void checkValidUrl(String url, String errorMsg) {
        Preconditions.checkEmptyString(url, errorMsg);
        Preconditions.check(Preconditions.isUrl(url), errorMsg);
    }

    public static void checkValidOAuthCallback(String url, String errorMsg) {
        Preconditions.checkEmptyString(url, errorMsg);
        if (url.toLowerCase(Locale.getDefault()).compareToIgnoreCase("oob") != 0) {
            Preconditions.check(Preconditions.isUrl(url), errorMsg);
        }
    }

    private static boolean isUrl(String url) {
        return Pattern.compile(URL_REGEXP).matcher(url).matches();
    }

    private static void check(boolean requirements, String error) {
        if (!requirements) {
            throw new IllegalArgumentException(error == null || error.trim().length() <= 0 ? DEFAULT_MESSAGE : error);
        }
    }
}

