/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.CompletedFuture;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.concurrent.Future;

class OAuth20ServiceUnit
extends OAuth20Service {
    static final String TOKEN = "ae82980abab675c646a070686d5558ad";
    static final String STATE = "123";
    static final String EXPIRES = "3600";

    OAuth20ServiceUnit(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    protected OAuth2AccessToken sendAccessTokenRequestSync(OAuthRequest request) {
        return new OAuth2AccessToken(TOKEN, this.prepareRawResponse(request));
    }

    private String prepareRawResponse(OAuthRequest request) {
        Gson json = new Gson();
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("access_token", TOKEN);
        response.put("state", STATE);
        response.put("expires_in", EXPIRES);
        response.putAll(request.getHeaders());
        response.putAll(request.getOauthParameters());
        request.getBodyParams().getParams().forEach(p -> response.put("query-" + p.getKey(), p.getValue()));
        return json.toJson(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequest request, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(TOKEN, this.prepareRawResponse(request));
        try {
            CompletedFuture<OAuth2AccessToken> completedFuture = new CompletedFuture<OAuth2AccessToken>(accessToken);
            return completedFuture;
        }
        finally {
            if (callback != null) {
                callback.onCompleted((Object)accessToken);
            }
        }
    }
}

